﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FacturacionSDK;

namespace Demo_Csharp_MFSDK
{
    public partial class Form1 : Form
    {
        MFSDK sdk;
        public Form1()
        {
            InitializeComponent();
            sdk = new MFSDK();
        }

        /// <summary>
        ///Nodo para la configuración del PAC
        /// </summary>
        public MFObject PAC()
        {
            MFObject pac = new MFObject("PAC");
            pac["usuario"] = "DEMO700101XXX";
            pac["pass"] = "DEMO700101XXX";
            pac["produccion"] = "NO";
            return pac;
        }

        /// <summary>
        ///Nodo para la configuración del PAC sin campo produccion
        /// </summary>
        public MFObject PAC2()
        {
            MFObject pac = new MFObject("PAC");
            pac["usuario"] = "DEMO700101XXX";
            pac["pass"] = "DEMO700101XXX";
            return pac;
        }

        /// <summary>
        ///Nodo para la configuración de certificados
        /// </summary>
        public MFObject Conf()
        {
            MFObject conf = new MFObject("conf");
            conf["cer"] = @"C:\SDK2\certificados\lan7008173r5.cer.pem";
            conf["key"] = @"C:\SDK2\certificados\lan7008173r5.key.pem";
            conf["pass"] = "12345678a";
            return conf;
        }

        /// <summary>
        ///Ejemplo consulta de saldo
        /// </summary>
        public void ejemplo_consulta_saldo()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("SALDO", "SI");
            sdk.AgregaObjeto(PAC2());
            MostrarDatos(sdk);
        }

        /// <summary>
        ///Ejemplo de cancelación de factura
        /// </summary>
        public void ejemplo_cancela_factura()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("cfdi", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("cancelar", "SI");
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            MostrarDatos(sdk);
        }

        public void MostrarDatos(MFSDK sdk)
        {
            textBox2.Clear();
            treeView1.Nodes.Clear();
            TreeNode raiz = new TreeNode("Archivo INI");
            treeView1.Nodes.Add(raiz);
            foreach (KeyValuePair<string, string> campo in sdk.Iniciales)
            {
                TreeNode inicia = new TreeNode(campo.Key + "=" + campo.Value);
                raiz.Nodes.Add(inicia);
            }
            sdk.AsignaValor();
            foreach (KeyValuePair<string, MFObject> sub in sdk.Apartados)
            {
                string nombre = sub.Key;
                TreeNode aparta = new TreeNode(nombre);
                foreach (KeyValuePair<string, string> dato in sub.Value.Atributos)
                {
                    TreeNode info = new TreeNode(dato.Key + "=" + dato.Value);
                    aparta.Nodes.Add(info);
                }
                raiz.Nodes.Add(aparta);
                if (sub.Value.Subnodos.Count > 0)
                {
                    foreach (KeyValuePair<string, MFObject> subnodo in sub.Value.Subnodos)
                    {
                        string aps = nombre + "." + subnodo.Key;
                        recorreSubnodos(aps, subnodo.Value, aparta);
                    }
                }
            }
            treeView1.ExpandAll();
        }

        public void recorreSubnodos(string apartado, MFObject subnodo, TreeNode padre)
        {
            TreeNode hijo = new TreeNode(apartado);
            foreach (KeyValuePair<string, string> dato in subnodo.Atributos)
            {
                TreeNode info = new TreeNode(dato.Key + "=" + dato.Value);
                hijo.Nodes.Add(info);
            }
            padre.Nodes.Add(hijo);
            foreach (KeyValuePair<string, MFObject> dato in subnodo.Subnodos)
            {
                string respaldo = apartado;
                string nombre = dato.Key;
                apartado += "." + nombre;
                recorreSubnodos(apartado, dato.Value, hijo);
                apartado = respaldo;
            }
        }

        /// <summary>
        ///Nodo complemento de todos los tipos de nómina 
        /// </summary>
        public MFObject complementoNominaTodo()
        {
            MFObject nomina = new MFObject("Nomina");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016 - 10 - 31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "7500.05";
            nomina["TotalDeducciones"] = "1234.09";
            nomina["TotalOtrosPagos"] = "0.0";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["Departamento"] = "";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nreceptor["Sindicalizado"] = "";
            nreceptor["TipoJornada"] = "";

            //subcontratación
            MFObject subcontratacion = new MFObject("SubContratacion");
            subcontratacion["RfcLabora"] = "VOC990129I26";
            subcontratacion["PorcentajeTiempo"] = "100.00";
            nreceptor.AgregaSubnodo(subcontratacion);
            nomina.AgregaSubnodo(nreceptor);

            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            //Complemento NominaGobierno
            MFObject entidad = new MFObject("EntidadSNCF");
            entidad["OrigenRecurso"] = "IF";
            nemisor.AgregaSubnodo(entidad);
            nomina.AgregaSubnodo(nemisor);

            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "7500.05";
            npercepciones["TotalExento"] = "0.00";
            npercepciones["TotalSueldos"] = "7500.05";
            npercepciones["TotalSeparacionIndemnizacion"] = "15000.00";
            npercepciones["TotalJubilacionPensionRetiro"] = "21300.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "6250.05";
            nper0["ImporteExento"] = "0.00";
            MFObject nper1 = new MFObject("1");
            nper1["TipoPercepcion"] = "049";
            nper1["Clave"] = "014";
            nper1["Concepto"] = "Premios de asistencia";
            nper1["ImporteGravado"] = "625.00";
            nper1["ImporteExento"] = "0.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "010";
            nper2["Clave"] = "013";
            nper2["Concepto"] = "Premios por puntualidad";
            nper2["ImporteGravado"] = "625.00";
            nper2["ImporteExento"] = "0.00";

            //Complemento horas extra
            MFObject horasextra = new MFObject("HorasExtra");
            MFObject hora0 = new MFObject("0");
            hora0["Dias"] = "2";
            hora0["TipoHoras"] = "01";
            hora0["HorasExtra"] = "8";
            hora0["ImportePagado"] = "105.70";
            MFObject hora1 = new MFObject("1");
            hora1["Dias"] = "1";
            hora1["TipoHoras"] = "02";
            hora1["HorasExtra"] = "6";
            hora1["ImportePagado"] = "1000.00";
            horasextra.AgregaSubnodo(hora0);
            horasextra.AgregaSubnodo(hora1);
            nper2.AgregaSubnodo(horasextra);
            MFObject percepcion3 = new MFObject("3");
            percepcion3["TipoPercepcion"] = "045";
            percepcion3["Clave"] = "045";
            percepcion3["Concepto"] = "Premios por puntualidad";
            percepcion3["ImporteGravado"] = "3000.00";
            percepcion3["ImporteExento"] = "0.00";
            //Complemento acciones
            MFObject acciones = new MFObject("AccionesOTitulos");
            acciones["ValorMercado"] = "1000.00";
            acciones["PrecioAlOtorgarse"] = "2000.00";
            percepcion3.AgregaSubnodo(acciones);
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper1);
            npercepciones.AgregaSubnodo(nper2);
            npercepciones.AgregaSubnodo(percepcion3);
            //Complemento jubilación
            MFObject jubilacion = new MFObject("JubilacionPensionRetiro");
            jubilacion["IngresoAcumulable"] = "1000.00";
            jubilacion["IngresoNoAcumulable"] = "300.00";
            jubilacion["TotalUnaExhibicion"] = "20000.00";
            npercepciones.AgregaSubnodo(jubilacion);
            //Complemento separación
            MFObject separacion = new MFObject("SeparacionIndemnizacion");
            separacion["TotalPagado"] = "15000.00";
            separacion["NumAñosServicio"] = "3";
            separacion["UltimoSueldoMensOrd"] = "5000.00";
            separacion["IngresoAcumulable"] = "3000.00";
            separacion["IngresoNoAcumulable"] = "1000.00";
            npercepciones.AgregaSubnodo(separacion);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "179.34";
            ndeducciones["TotalImpuestosRetenidos"] = "1054.75";
            MFObject nded0 = new MFObject("Nomina.Deducciones.0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "1054.75";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "179.34";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);
            //Complemento otros pagos
            MFObject pagos = new MFObject("OtrosPagos");
            MFObject pago0 = new MFObject("0");
            pago0["TipoOtroPago"] = "002";
            pago0["Clave"] = "012";
            pago0["Concepto"] = "Subsidio para el empleo";
            pago0["Importe"] = "5000.00";
            //Complemento subsidio
            MFObject subsidio = new MFObject("SubsidioAlEmpleo");
            subsidio["SubsidioCausado"] = "5000.00";

            //Compensación saldos a favor
            MFObject compensacion = new MFObject("CompensacionSaldosAFavor");
            compensacion["SaldoAFavor"] = "300.00";
            compensacion["Año"] = "2017";
            compensacion["RemanenteSalFav"] = "100.00";
            pago0.AgregaSubnodo(compensacion);
            pago0.AgregaSubnodo(subsidio);
            pagos.AgregaSubnodo(pago0);
            nomina.AgregaSubnodo(pagos);
            // Incapacidades
            MFObject incapacidades = new MFObject("Incapacidades");
            MFObject incapacidad0 = new MFObject("0");
            incapacidad0["DiasDeIncapacidad"] = "2";
            incapacidad0["TipoIncapacidad"] = "01";
            incapacidad0["ImporteMonetario"] = "300.00";
            incapacidades.AgregaSubnodo(incapacidad0);
            nomina.AgregaSubnodo(incapacidades);
            return nomina;
        }

        /// <summary>
        ///Nodo complemento de comercio exterior
        /// </summary>
        public MFObject complementoComercio()
        {
            MFObject comercio = new MFObject("Comercio");
            comercio["TipoOperacion"] = "2";
            comercio["ClaveDePedimento"] = "A1";
            comercio["CertificadoOrigen"] = "0";
            comercio["NumeroExportadorConfiable"] = "0";
            comercio["Incoterm"] = "FOB";
            comercio["Subdivision"] = "0";
            comercio["Observaciones"] = "detalles";
            comercio["TipoCambioUSD"] = "10.23";
            comercio["TotalUSD"] = "116.00";
            //Receptor de comercio
            MFObject creceptor = new MFObject("Receptor");
            creceptor["Curp"] = "HEUJ880222HOCTRR04";
            creceptor["NumRegIdTrib"] = "123456789";
            comercio.AgregaSubnodo(creceptor);
            //Destinatario de comercio
            MFObject cdestinatario = new MFObject("Destinatario");
            cdestinatario["NumRegIdTrib"] = "123456789";
            cdestinatario["Rfc"] = "ESI920427886";
            cdestinatario["Curp"] = "HIOK800212HOCTRR01";
            cdestinatario["Nombre"] = "str1234";
            //Domicilio
            MFObject domicilio = new MFObject("Domicilio");
            domicilio["Calle"] = "calle de pruebas";
            domicilio["NumeroExterior"] = "1234";
            domicilio["Colonia"] = "0995";
            domicilio["Localidad"] = "11";
            domicilio["Referencia"] = "str1234";
            domicilio["Municipio"] = "035";
            domicilio["Estado"] = "COA";
            domicilio["Pais"] = "MEX";
            domicilio["CodigoPostal"] = "27000";
            cdestinatario.AgregaSubnodo(domicilio);
            comercio.AgregaSubnodo(cdestinatario);
            //Mercancías
            MFObject mercancias = new MFObject("Mercancias");
            MFObject merc0 = new MFObject("0");
            merc0["NoIdentificacion"] = "A-1215";
            merc0["FraccionArancelaria"] = "01011001";
            merc0["CantidadAduana"] = "1.0";
            merc0["UnidadAduana"] = "1";
            merc0["ValorUnitarioAduana"] = "116.00";
            merc0["ValorDolares"] = "116.00";
            //Descripciones
            MFObject descs = new MFObject("DescripcionesEspecificas");
            MFObject desc0 = new MFObject("0");
            desc0["Marca"] = "YAMAHA";
            desc0["Modelo"] = "DDA - 21";
            desc0["SubModelo"] = "DDD1";
            desc0["NumeroSerie"] = "3292383823";
            MFObject desc1 = new MFObject("1");
            desc1["Marca"] = "str12342";
            desc1["Modelo"] = "str12342";
            desc1["SubModelo"] = "str12342";
            desc1["NumeroSerie"] = "3292383823";
            descs.AgregaSubnodo(desc0);
            descs.AgregaSubnodo(desc1);
            merc0.AgregaSubnodo(descs);
            mercancias.AgregaSubnodo(merc0);
            comercio.AgregaSubnodo(mercancias);
            return comercio;
        }

        /// <summary>
        ///Nodo complemento INE
        /// </summary>
        public MFObject complementoINE()
        {
            MFObject ine = new MFObject("INE");
            ine["TipoProceso"] = "Campaña";
            MFObject entidad = new MFObject("Entidad");
            MFObject entidad0 = new MFObject("0");
            entidad0["ClaveEntidad"] = "TAM";
            entidad0["Ambito"] = "Local";
            entidad.AgregaSubnodo(entidad0);
            MFObject conta = new MFObject("Contabilidad");
            MFObject conta0 = new MFObject("0");
            conta0["idContabilidad"] = "010648";
            conta.AgregaSubnodo(conta0);
            entidad.AgregaSubnodo(conta);
            ine.AgregaSubnodo(entidad);
            return ine;
        }

        /// <summary>
        ///Nodo complemento de notarios públicos
        /// </summary>
        public MFObject complementoNotariosPublicos()
        {
            // Notario Publico
            MFObject notario = new MFObject("NotariosPublicos");
            notario["CURP"] = "AAQM010101HCSMNZ00";
            notario["NumNotaria"] = "3";
            notario["EntidadFederativa"] = "16";
            notario["Adscripcion"] = "Guanajuato";
            // Descripcion de inmuebles
            MFObject inmuebles = new MFObject("DescInmuebles");
            MFObject inmueble0 = new MFObject("0");
            inmueble0["Calle"] = "Av. Siempre Viva";
            inmueble0["CodigoPostal"] = "12345";
            inmueble0["Colonia"] = "Bondojito";
            inmueble0["Estado"] = "14";
            inmueble0["Localidad"] = "Oaxaca";
            inmueble0["Municipio"] = "Oaxaca";
            inmueble0["NoExterior"] = "123";
            inmueble0["NoInterior"] = "B";
            inmueble0["Pais"] = "MEX";
            inmueble0["TipoInmueble"] = "01";
            inmuebles.AgregaSubnodo(inmueble0);
            notario.AgregaSubnodo(inmuebles);
            //Datos de operación
            MFObject datosOperacion = new MFObject("DatosOperacion");
            datosOperacion["NumInstrumentoNotarial"] = "12345";
            datosOperacion["FechaInstNotarial"] = "2014-04-22";
            datosOperacion["MontoOperacion"] = "1234.56";
            datosOperacion["Subtotal"] = "1234.56";
            datosOperacion["IVA"] = "1234.56";
            notario.AgregaSubnodo(datosOperacion);

            /* Datos de Varios Enajenantes
            MFObject enajenantes = new MFObject("NotariosPublicos.DatosEnajenantesCopSC");
            MFObject enajenante0 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.0");
            enajenante0["Nombre"] = "Enajenante 1";
            enajenante0["ApellidoPaterno"] = "Apellido Paterno";
            enajenante0["ApellidoMaterno"] = "Apellido Materno";
            enajenante0["RFC"] = "HSJ600903MN0";
            enajenante0["CURP"] = "OAAJ840102HJCVRN00";
            enajenante0["Porcentaje"] = "50";
            enajenantes.AgregaSubnodo(enajenante0);

            MFObject enajenante1 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.1");
            enajenante1["Nombre"] = "Enajenante 2";
            enajenante1["ApellidoPaterno"] = "Apellido Paterno";
            enajenante1["ApellidoMaterno"] = "Apellido Materno";
            enajenante1["RFC"] = "MSB600304KL9";
            enajenante1["CURP"] = "OAAJ840102HJCVRN00";
            enajenante1["Porcentaje"] = "50";
            enajenantes.AgregaSubnodo(enajenante1);

            DatosEnajenante datosEnajenante = new DatosEnajenante();
            datosEnajenante.CoproSocConyugalE = "Si";
            datosEnajenante.DatosEnajenanteCopSC = enajenantes;
            */
            // Datos para un Solo Enajenante
            MFObject unenajenante = new MFObject("DatosUnEnajenante");
            unenajenante["Nombre"] = "Enajenante";
            unenajenante["ApellidoPaterno"] = "Apellido Paterno";
            unenajenante["ApellidoMaterno"] = "Apellido Materno";
            unenajenante["RFC"] = "HSJ600903MN0";
            unenajenante["CURP"] = "OAAJ840102HJCVRN00";

            MFObject datosEnajenante = new MFObject("DatosEnajenante");
            datosEnajenante["CoproSocConyugalE"] = "No";
            datosEnajenante.AgregaSubnodo(unenajenante);
            notario.AgregaSubnodo(datosEnajenante);

            /* Datos de Varios Adquirientes
            MFObject adquirientes = new MFObject("DatosAdquirientesCopSC");
            MFObject adquiriente0 = new MFObject("0");
            adquiriente0["Nombre"] = "Adquiriente 1";
            adquiriente0["ApellidoPaterno"] = "Apellido Paterno";
            adquiriente0["ApellidoMaterno"] = "Apellido Materno";
            adquiriente0["RFC"] = "HSJ600903MN0";
            adquiriente0["CURP"] = "OAAJ840102HJCVRN00";
            adquiriente0["Porcentaje"] = "50";
            adquirientes.AgregaSubnodo(adquiriente0);

            MFObject adquiriente1 = new MFObject("1");
            adquiriente1["Nombre"] = "Adquiriente 2";
            adquiriente1["ApellidoPaterno"] = "Apellido Paterno";
            adquiriente1["ApellidoMaterno"] = "Apellido Materno";
            adquiriente1["RFC"] = "MSB600304KL9";
            adquiriente1["CURP"] = "OAAJ840102HJCVRN00";
            adquiriente1["Porcentaje"] = "50";
            adquirientes.AgregaSubnodo(adquiriente1);

            MFObject datosAdquiriente = new MFObject("DatosAdquiriente");
            datosAdquiriente["CoproSocConyugalE"] = "Si";
            datosAdquiriente.AgregaSubnodo(adquirientes);
            notario.AgregaSubnodo(datosAdquiriente);
            */

            // Datos un Solo Adquiriente
            MFObject unadquiriente = new MFObject("DatosUnAdquiriente");
            unadquiriente["Nombre"] = "Adquiriente";
            unadquiriente["ApellidoPaterno"] = "Apellido Paterno";
            unadquiriente["ApellidoMaterno"] = "Apellido Materno";
            unadquiriente["RFC"] = "HSJ600903MN0";
            unadquiriente["CURP"] = "OAAJ840102HJCVRN00";

            MFObject datosAdquiriente = new MFObject("DatosAdquiriente");
            datosAdquiriente["CoproSocConyugalE"] = "No";
            datosAdquiriente.AgregaSubnodo(unadquiriente);
            notario.AgregaSubnodo(datosAdquiriente);
            return notario;
        }

        /// <summary>
        ///Nodo complemento escuelas
        /// </summary>
        public MFObject complementoEscuela()
        {
            // IEDU
            MFObject iedu = new MFObject("IEDU");
            iedu["nombreAlumno"] = "FULANITO PEREZ OCHOA";
            iedu["CURP"] = "MAGC870912HGTRRS06";
            iedu["nivelEducativo"] = "Preescolar";
            iedu["autRVOE"] = "1234-ABC";
            iedu["RFCPago"] = "SOHM7509289MA";
            return iedu;
        }

        /// <summary>
        ///Nodo complemento hoteles
        /// </summary>
        public MFObject complementoHoteles()
        {
            //Hoteles
            // Impuestos Locales
            MFObject locales = new MFObject("ImpuestosLocales");
            MFObject trasLocales = new MFObject("TrasladoLocal");
            MFObject trasLocal0 = new MFObject("0");
            trasLocal0["ImpLocTrasladado"] = "ISH";
            trasLocal0["Importe"] = "10";
            trasLocal0["TasadeTraslado"] = "3";
            trasLocales.AgregaSubnodo(trasLocal0);
            locales.AgregaSubnodo(trasLocales);
            return locales;
        }

        /// <summary>
        ///Nodo complemento terceros
        /// </summary>
        public MFObject complementoTerceros()
        {
            MFObject terceros = new MFObject("terceros11");
            terceros["rfc"] = "SOHM7509289MA";
            terceros["nombre"] = "maria";
            //Domicilio
            MFObject domTercero = new MFObject("InformacionFiscalTercero");
            domTercero["Calle"] = "JUAREZ";
            domTercero["CodigoPostal"] = "64610";
            domTercero["Estado"] = "NUEVO LEON";
            domTercero["Municipio"] = "MONTERREY";
            domTercero["Localidad"] = "MONTERREY";
            domTercero["Pais"] = "MEXICO";
            domTercero["NoExterior"] = "7";
            domTercero["NoInterior"] = "A";
            domTercero["Colonia"] = "DEL VALLE";
            domTercero["referencia"] = "nuirenfuf";
            terceros.AgregaSubnodo(domTercero);
            //Informaciñon aduanera
            MFObject info = new MFObject("InformacionAduanera");
            info["numero"] = "2331";
            info["fecha"] = "2016-10-31";
            info["aduana"] = "miaduana";
            terceros.AgregaSubnodo(info);
            //Partes
            MFObject partes = new MFObject("Parte");
            MFObject part0 = new MFObject("0");
            part0["cantidad"] = "1";
            part0["unidad"] = "pieza";
            part0["noIdentificacion"] = "56";
            part0["descripcion"] = "56vs";
            part0["valorUnitario"] = "1000";
            part0["importe"] = "1000";
            MFObject p0infos = new MFObject("InformacionAduanera");
            MFObject p0info0 = new MFObject("0");
            p0info0["numero"] = "15";
            p0info0["fecha"] = "2017-05-25";
            p0info0["aduana"] = "56vs";
            p0infos.AgregaSubnodo(p0info0);
            part0.AgregaSubnodo(p0infos);
            partes.AgregaSubnodo(part0);
            terceros.AgregaSubnodo(partes);
            //Cuenta predial
            MFObject predial = new MFObject("CuentaPredial");
            predial["numero"] = "56";
            terceros.AgregaSubnodo(predial);
            //Impuestos
            MFObject impuestos = new MFObject("Impuestos");
            MFObject retenciones = new MFObject("Retenciones");
            MFObject ret0 = new MFObject("0");
            ret0["impuesto"] = "001";
            ret0["importe"] = "0.00";
            MFObject traslados = new MFObject("Traslados");
            MFObject tra0 = new MFObject("0");
            tra0["impuesto"] = "003";
            tra0["tasa"] = "0.16";
            tra0["importe"] = "0.00";
            retenciones.AgregaSubnodo(ret0);
            traslados.AgregaSubnodo(tra0);
            impuestos.AgregaSubnodo(retenciones);
            impuestos.AgregaSubnodo(traslados);
            terceros.AgregaSubnodo(impuestos);
            return terceros;
        }

        /// <summary>
        ///Nodo complemento de impuestos locales
        /// </summary>
        public MFObject complementoImpLocales()
        {
            // Impuestos Locales
            MFObject locales = new MFObject("ImpuestosLocales");
            MFObject retLocales = new MFObject("RetencionLocal");
            MFObject retLocal0 = new MFObject("0");
            retLocal0["ImpLocTrasladado"] = "ABC";
            retLocal0["TasadeTraslado"] = "2";
            retLocal0["Importe"] = "11";
            MFObject retLocal1 = new MFObject("1");
            retLocal1["ImpLocTrasladado"] = "DEF";
            retLocal1["TasadeTraslado"] = "3";
            retLocal1["Importe"] = "13";
            retLocales.AgregaSubnodo(retLocal0);
            retLocales.AgregaSubnodo(retLocal1);
            MFObject trasLocales = new MFObject("TrasladoLocal");
            MFObject trasLocal0 = new MFObject("0");
            trasLocal0["ImpLocTrasladado"] = "XYZ";
            trasLocal0["TasadeTraslado"] = "3";
            trasLocal0["Importe"] = "10";
            MFObject trasLocal1 = new MFObject("1");
            trasLocal1["ImpLocTrasladado"] = "ASD";
            trasLocal1["TasadeTraslado"] = "3";
            trasLocal1["Importe"] = "10";
            trasLocales.AgregaSubnodo(trasLocal0);
            trasLocales.AgregaSubnodo(trasLocal1);
            locales.AgregaSubnodo(retLocales);
            locales.AgregaSubnodo(trasLocales);
            return locales;
        }

        /// <summary>
        ///Nodo complemento parciales construcción
        /// </summary>
        public MFObject complementoParcialesConstruccion()
        {
            MFObject parciales = new MFObject("ParcialesConstruccion");
            parciales["NumPerLicoAut"] = "12345678901234567890";
            MFObject inmueble = new MFObject("Inmueble");
            inmueble["Calle"] = "Juarez";
            inmueble["NoExterior"] = "1025";
            inmueble["NoInterior"] = "5";
            inmueble["Colonia"] = "Centro";
            inmueble["Localidad"] = "Torreon";
            inmueble["Referencia"] = "Entre Hidalgo y Morelos";
            inmueble["Municipio"] = "Torreon";
            inmueble["Estado"] = "09";
            inmueble["CodigoPostal"] = "27054";
            parciales.AgregaSubnodo(inmueble);
            return parciales;
        }

        /// <summary>
        ///Nodo complemento acreditamiento IEPS
        /// </summary>
        public MFObject complementoAcreditamientoIEPS()
        {
            MFObject acredita = new MFObject("AcreditamientoIEPS");
            acredita["TAR"] = "690";
            return acredita;
        }

        /// <summary>
        ///Nodo complemento aerolineas
        /// </summary>
        public MFObject complementoAerolineas()
        {
            MFObject aerolineas = new MFObject("Aerolineas");
            aerolineas["TUA"] = "2000.00";
            MFObject otrosCargos = new MFObject("OtrosCargos");
            otrosCargos["TotalCargos"] = "2";
            MFObject cargo0 = new MFObject("0");
            cargo0["CodigoCargo"] = "22990";
            cargo0["Importe"] = "1000.00";
            MFObject cargo1 = new MFObject("1");
            cargo1["CodigoCargo"] = "14678";
            cargo1["Importe"] = "1000.00";
            otrosCargos.AgregaSubnodo(cargo0);
            otrosCargos.AgregaSubnodo(cargo1);
            aerolineas.AgregaSubnodo(otrosCargos);
            return aerolineas;
        }

        /// <summary>
        ///Nodo complemento certificado de destrucción
        /// </summary>
        public MFObject complementoCertificadoDestruccion()
        {
            MFObject destruccion = new MFObject("CertificadoDeDestruccion");
            destruccion["Serie"] = "27833";
            destruccion["NumFolDesVeh"] = "A1";

            MFObject vehiculo = new MFObject("VehiculoDestruido");
            vehiculo["Marca"] = "ford";
            vehiculo["Año"] = "2000";
            vehiculo["Modelo"] = "FOB";
            vehiculo["NIV"] = "te0";
            vehiculo["NumSerie"] = "gera43";
            vehiculo["NumPlacas"] = "1034";
            vehiculo["NumMotor"] = "116";
            vehiculo["NumFolTarjCir"] = "DESO801116HGTLRS08";

            MFObject infoa = new MFObject("InformacionAduanera");
            infoa["NumPedImp"] = "HEUJ880222HOCTRR04";
            infoa["Fecha"] = "05-04-2017";
            infoa["Aduana"] = "123456789";
            destruccion.AgregaSubnodo(vehiculo);
            destruccion.AgregaSubnodo(infoa);
            return destruccion;
        }

        /// <summary>
        ///Nodo complemento CFDI Registro fiscal
        /// </summary>
        public MFObject complementoCFDIRegistroFiscal()
        {
            MFObject regfis = new MFObject("CFDIRegistroFiscal");
            regfis["Folio"] = "29547033879512844";
            return regfis;
        }

        /// <summary>
        ///Nodo complemento consumo de combustibles
        /// </summary>
        public MFObject complementoConsumoCombustibles()
        {
            MFObject consumo = new MFObject("ConsumoDeCombustibles");
            consumo["tipoOperacion"] = "gref";
            consumo["numeroDeCuenta"] = "908545";
            consumo["subTotal"] = "8947.50";
            consumo["total"] = "12345.50";

            MFObject conceptos = new MFObject("Conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["identificador"] = "123";
            concepto0["fecha"] = "05-04-2017";
            concepto0["rfc"] = "gaar930830mcl";
            concepto0["claveEstacion"] = "8";
            concepto0["cantidad"] = "4";
            concepto0["nombreCombustible"] = "oil";
            concepto0["folioOperacion"] = "243";
            concepto0["valorUnitario"] = "35.50";
            concepto0["importe"] = "142.00";

            MFObject determinados = new MFObject("Determinados");
            MFObject det0 = new MFObject("0");
            det0["impuesto"] = "IVA";
            det0["tasa"] = "0.16";
            det0["importe"] = "130.00";
            MFObject det1 = new MFObject("1");
            det1["impuesto"] = "IEPS";
            det1["tasa"] = "0.17";
            det1["importe"] = "135.00";
            determinados.AgregaSubnodo(det0);
            determinados.AgregaSubnodo(det1);
            concepto0.AgregaSubnodo(determinados);
            conceptos.AgregaSubnodo(concepto0);

            MFObject concepto1 = new MFObject("1");
            concepto1["identificador"] = "456";
            concepto1["fecha"] = "05-04-2017";
            concepto1["rfc"] = "gaar930830mcl";
            concepto1["claveEstacion"] = "8";
            concepto1["cantidad"] = "4";
            concepto1["nombreCombustible"] = "oil";
            concepto1["folioOperacion"] = "243";
            concepto1["valorUnitario"] = "35.50";
            concepto1["importe"] = "142.00";

            MFObject con1dets = new MFObject("Determinados");
            MFObject con1det0 = new MFObject("0");
            con1det0["impuesto"] = "IVA";
            con1det0["tasa"] = "0.16";
            con1det0["importe"] = "130.00";
            con1dets.AgregaSubnodo(con1det0);
            concepto1.AgregaSubnodo(con1dets);
            conceptos.AgregaSubnodo(concepto1);
            consumo.AgregaSubnodo(conceptos);
            return consumo;
        }

        /// <summary>
        ///Nodo complemento divisas
        /// </summary>
        public MFObject complementoDivisas()
        {
            MFObject divisas = new MFObject("Divisas");
            divisas["tipoOperacion"] = "compra";
            return divisas;
        }

        /// <summary>
        ///Nodo complemento donatarias
        /// </summary>
        public MFObject complementoDonatarias()
        {
            MFObject donat = new MFObject("Donatarias");
            donat["noAutorizacion"] = "29";
            donat["fechaAutorizacion"] = "05-04-2017";
            donat["leyenda"] = "mileyenda";
            return donat;
        }

        /// <summary>
        ///Nodo complemento estado de cuenta de combustible
        /// </summary>
        public MFObject complementoEstadoCuentaComb()
        {
            MFObject ecc = new MFObject("EstadoDeCuentaCombustible");
            ecc["TipoOperacion"] = "gref";
            ecc["NumeroDeCuenta"] = "908545";
            ecc["SubTotal"] = "8947.50";
            ecc["Total"] = "12345.50";

            MFObject conceptos = new MFObject("Conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["Identificador"] = "123";
            concepto0["Fecha"] = "05-04-2017";
            concepto0["Rfc"] = "gaar930830mcl";
            concepto0["ClaveEstacion"] = "8";
            concepto0["TAR"] = "667";
            concepto0["Cantidad"] = "4";
            concepto0["NoIdentificacion"] = "51";
            concepto0["Unidad"] = "32011";
            concepto0["NombreCombustible"] = "oil";
            concepto0["FolioOperacion"] = "243";
            concepto0["ValorUnitario"] = "35.50";
            concepto0["Importe"] = "142.00";

            MFObject traslados = new MFObject("Traslados");
            MFObject tras0 = new MFObject("0");
            tras0["Impuesto"] = "IVA";
            tras0["TasaoCuota"] = "0.16";
            tras0["Importe"] = "130.00";
            MFObject tras1 = new MFObject("1");
            tras1["Impuesto"] = "IEPS";
            tras1["TasaoCuota"] = "0.17";
            tras1["Importe"] = "135.00";
            traslados.AgregaSubnodo(tras0);
            traslados.AgregaSubnodo(tras1);
            concepto0.AgregaSubnodo(traslados);
            conceptos.AgregaSubnodo(concepto0);

            MFObject concepto1 = new MFObject("1");
            concepto1["Identificador"] = "456";
            concepto1["Fecha"] = "05-04-2017";
            concepto1["Rfc"] = "gaar930830mcl";
            concepto1["ClaveEstacion"] = "8";
            concepto1["TAR"] = "667";
            concepto1["Cantidad"] = "4";
            concepto1["NoIdentificacion"] = "51";
            concepto1["Unidad"] = "32011";
            concepto1["NombreCombustible"] = "oil";
            concepto1["FolioOperacion"] = "243";
            concepto1["ValorUnitario"] = "35.50";
            concepto1["Importe"] = "142.00";

            MFObject con0tras0 = new MFObject("0");
            con0tras0["Impuesto"] = "IEPS";
            con0tras0["TasaoCuota"] = "0.16";
            con0tras0["Importe"] = "130.00";
            concepto0.AgregaSubnodo(con0tras0);
            conceptos.AgregaSubnodo(concepto1);
            ecc.AgregaSubnodo(conceptos);
            return ecc;
        }

        /// <summary>
        ///Nodo complemento leyendas fiscales
        /// </summary>
        public MFObject complementoLeyendasFisc()
        {
            MFObject leyendas = new MFObject("LeyendasFiscales");
            MFObject ley0 = new MFObject("0");
            MFObject ley1 = new MFObject("1");
            ley0["disposicionFiscal"] = "htr";
            ley0["norma"] = "grea";
            ley0["textoLeyenda"] = "ergtr";

            ley1["disposicionFiscal"] = "hrdy";
            ley1["norma"] = "dwq";
            ley1["textoLeyenda"] = "fwe";
            leyendas.AgregaSubnodo(ley0);
            leyendas.AgregaSubnodo(ley1);
            return leyendas;
        }

        /// <summary>
        ///Nodo complemento obras y antigüedades
        /// </summary>
        public MFObject complementoObrasAntiguedades()
        {
            MFObject arte = new MFObject("ObrasArteAntiguedades");
            arte["TipoBien"] = "02";
            arte["OtrosTipoBien"] = "miarte";
            arte["TituloAdquirido"] = "03";
            arte["OtrosTituloAdquirido"] = "mititulo";
            arte["Subtotal"] = "160.00";
            arte["IVA"] = "16.00";
            arte["FechaAdquisicion"] = "05-04-2017";
            arte["CaracterísticasDeObraoPieza"] = "07";
            return arte;
        }

        /// <summary>
        ///Nodo complemento pago en especie
        /// </summary>
        public MFObject complementoPagoEnEspecie()
        {
            MFObject pagos = new MFObject("PagoEnEspecie");
            pagos["CvePIC"] = "X100081000986725341974620";//[A-ZÑ&]{3}[0-9]{2}[0-1][0-9][0-3][0-9][A-Z0-9]?[A-Z0-9]?[0-9A-Z]-(18|19|20)\d\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])-[0-9]{3}
            pagos["FolioSolDon"] = "PE-22-12345";//PE-[0-9]{2}-[0-9]{5}
            pagos["PzaArtNombre"] = "Las Flores";
            pagos["PzaArtTecn"] = "Cubismo al Óleo";
            pagos["PzaArtAProd"] = "2013";
            pagos["PzaArtDim"] = "50cmx100cm";
            return pagos;
        }

        /// <summary>
        ///Nodo complemento PF integrante coordinado
        /// </summary>
        public MFObject complementoPFintegranteCoordinado()
        {
            MFObject pfic = new MFObject("PFIntegranteCoordinado");
            pfic["ClaveVehicular"] = "29547033879512844";
            pfic["Placa"] = "456543R";
            pfic["RFCPF"] = "FESRGTG43";
            return pfic;
        }

        /// <summary>
        ///Nodo complemento timbre fiscal digital
        /// </summary>
        public MFObject complementoTimbreFiscalDigital()
        {
            MFObject tfd = new MFObject("TimbreFiscalDigital");
            tfd["UUID"] = "29547033879512844";
            tfd["FechaTimbrado"] = "10-05-2017";
            tfd["selloCFD"] = "FESRGTG43";
            tfd["noCertificadoSAT"] = "456543R";
            tfd["selloSAT"] = "FESRGTG4323";
            return tfd;
        }

        /// <summary>
        ///Nodo complemento turista, pasajero, extranjero
        /// </summary>
        public MFObject complementoTuristaPE()
        {
            MFObject tpe = new MFObject("TuristaPasajeroExtranjero");
            tpe["fechadeTransito"] = "gref";
            tpe["tipoTransito"] = "908545";

            MFObject datosTransito = new MFObject("datosTransito");
            datosTransito["Via"] = "4";
            datosTransito["TipoId"] = "05";
            datosTransito["NumeroId"] = "123";
            datosTransito["Nacionalidad"] = "Mexicana";
            datosTransito["EmpresaTransporte"] = "Chihuahuenses";
            datosTransito["IdTransporte"] = "80805";
            tpe.AgregaSubnodo(datosTransito);
            return tpe;
        }

        /// <summary>
        ///Nodo complemento vales de despensa
        /// </summary>
        public MFObject complementoValeDespensa()
        {
            MFObject vales = new MFObject("ValesDeDespensa");
            vales["tipoOperacion"] = "gref";
            vales["registroPatronal"] = "908545";
            vales["numeroDeCuenta"] = "8947.50";
            vales["total"] = "12345.50";

            MFObject conceptos = new MFObject("Conceptos");
            MFObject con0 = new MFObject("0");
            MFObject con1 = new MFObject("1");
            con0["identificador"] = "123";
            con0["fecha"] = "05-04-2017";
            con0["rfc"] = "gaar930830mcl";
            con0["curp"] = "8";
            con0["nombre"] = "4";
            con0["numSeguridadSocial"] = "oil";
            con0["importe"] = "142.00";

            con1["identificador"] = "456";
            con1["fecha"] = "05-04-2017";
            con1["rfc"] = "gaar930830mcl";
            con1["curp"] = "8";
            con1["nombre"] = "4";
            con1["numSeguridadSocial"] = "oil";
            con1["importe"] = "142.00";
            conceptos.AgregaSubnodo(con0);
            conceptos.AgregaSubnodo(con1);
            vales.AgregaSubnodo(conceptos);
            return vales;
        }

        /// <summary>
        ///Nodo complemento vehículos usados
        /// </summary>
        public MFObject complementoVehiculoUsado()
        {
            MFObject vehus = new MFObject("VehiculoUsado");
            vehus["montoAdquisicion"] = "2";
            vehus["montoEnajenacion"] = "A1";
            vehus["claveVehicular"] = "A1";
            vehus["marca"] = "A1";
            vehus["tipo"] = "A1";
            vehus["modelo"] = "A1";
            vehus["numeroMotor"] = "A1";
            vehus["numeroSerie"] = "A1";
            vehus["NIV"] = "A1";
            vehus["valor"] = "A1";
            //Información aduanera
            MFObject infoads = new MFObject("InformacionAduanera");
            MFObject info0 = new MFObject("0");
            info0["numero"] = "12";
            info0["fecha"] = "11-04-2017";
            info0["aduana"] = "gtr";
            MFObject info1 = new MFObject("1");
            info1["numero"] = "76";
            info1["fecha"] = "11-04-2017";
            info1["aduana"] = "oiu";
            infoads.AgregaSubnodo(info0);
            infoads.AgregaSubnodo(info1);
            vehus.AgregaSubnodo(infoads);
            return vehus;
        }

        /// <summary>
        ///Nodo complemento venta de vehículos
        /// </summary>
        public MFObject complementoVentaVehiculos()
        {
            MFObject veve = new MFObject("VentaVehiculos");
            veve["ClaveVehicular"] = "2";
            veve["Niv"] = "A1";
            //Información aduanera
            MFObject infoads = new MFObject("InformacionAduanera");
            MFObject info0 = new MFObject("0");
            info0["numero"] = "12";
            info0["fecha"] = "11-04-2017";
            info0["aduana"] = "gtr";
            MFObject info1 = new MFObject("1");
            info1["numero"] = "76";
            info1["fecha"] = "11-04-2017";
            info1["aduana"] = "oiu";
            infoads.AgregaSubnodo(info0);
            infoads.AgregaSubnodo(info1);
            veve.AgregaSubnodo(infoads);
            //Partes
            MFObject partes = new MFObject("Parte");
            MFObject part0 = new MFObject("0");
            part0["cantidad"] = "116.00";
            part0["unidad"] = "0";
            part0["noIdentificacion"] = "detalles";
            part0["descripcion"] = "10.23";
            part0["valorUnitario"] = "116.00";
            part0["importe"] = "116.00";

            MFObject infoads2 = new MFObject("InformacionAduanera");
            MFObject info02 = new MFObject("0");
            info02["numero"] = "2";
            info02["fecha"] = "10-04-2017";
            info02["aduana"] = "wed";
            MFObject info12 = new MFObject("1");
            info12["numero"] = "3";
            info12["fecha"] = "05-04-2017";
            info12["aduana"] = "ntu";
            infoads2.AgregaSubnodo(info02);
            infoads2.AgregaSubnodo(info12);
            part0.AgregaSubnodo(infoads2);
            MFObject part1 = new MFObject("1");
            part1["cantidad"] = "112";
            part1["unidad"] = "76";
            part1["noIdentificacion"] = "098";
            part1["descripcion"] = "kye";
            part1["valorUnitario"] = "119.00";
            part1["importe"] = "119.00";
            partes.AgregaSubnodo(part0);
            partes.AgregaSubnodo(part1);
            veve.AgregaSubnodo(partes);
            return veve;
        }
                
        /// <summary>
        ///Nodo complemento renovación y sustitución de vehículos
        /// </summary>
        public MFObject complementoRenovacionVehiculos()
        {
            //Renovación y sustitución de vehículos
            MFObject renysv = new MFObject("RenovacionYSustitucionVehiculos");
            renysv["TipoDeDecreto"] = "2";
            //Decreto de renovación vehicular
            MFObject decreto = new MFObject("DecretoRenovVehicular");
            decreto["VehEnaj"] = "A1";
            MFObject dec0 = new MFObject("0");
            dec0["PrecioVehUsado"] = "A1";
            dec0["TipoVeh"] = "A1";
            dec0["Marca"] = "A1";
            dec0["TipooClase"] = "A1";
            dec0["Año"] = "A1";
            dec0["Modelo"] = "A1";
            dec0["NIV"] = "A1";
            dec0["NumSerie"] = "A1";
            dec0["NumPlacas"] = "A1";
            dec0["NumMotor"] = "A1";
            dec0["NumFolTarjCir"] = "A1";
            dec0["NumPedIm"] = "A1";
            dec0["Aduana"] = "A1";
            dec0["FechaRegulVeh"] = "A1";
            dec0["Foliofiscal"] = "A1";
            decreto.AgregaSubnodo(dec0);
            //Vehículo
            MFObject venusenafalperm = new MFObject("VehiculoNuvoSemEnajenadoFabAlPerm");
            venusenafalperm["Año"] = "2012";
            venusenafalperm["Modelo"] = "fre";
            venusenafalperm["NumPlacas"] = "786dfsr";
            venusenafalperm["RFC"] = "fg4378gv86t2374";
            decreto.AgregaSubnodo(venusenafalperm);
            renysv.AgregaSubnodo(decreto);
            //Decreto de sustitución vehicular
            MFObject decretoSustit = new MFObject("DecretoSustitVehicular");
            decretoSustit["VehEnaj"] = "A1";
            //Vehículo
            MFObject veusenpealfa = new MFObject("VehiculoUsadoEnajenadoPermAlFab");
            veusenpealfa["PrecioVehUsado"] = "A1";
            veusenpealfa["TipoVeh"] = "A1";
            veusenpealfa["Marca"] = "A1";
            veusenpealfa["TipooClase"] = "A1";
            veusenpealfa["Año"] = "A1";
            veusenpealfa["Modelo"] = "A1";
            veusenpealfa["NIV"] = "A1";
            veusenpealfa["NumSerie"] = "A1";
            veusenpealfa["NumPlacas"] = "A1";
            veusenpealfa["NumMotor"] = "A1";
            veusenpealfa["NumFolTarjCir"] = "A1";
            veusenpealfa["NumFolAvisoint"] = "A1";
            veusenpealfa["NumPedIm"] = "A1";
            veusenpealfa["Aduana"] = "A1";
            veusenpealfa["FechaRegulVeh"] = "A1";
            veusenpealfa["Foliofiscal"] = "A1";
            decretoSustit.AgregaSubnodo(veusenpealfa);
            //Vehículo
            MFObject venusenafalperm2 = new MFObject("VehiculoNuvoSemEnajenadoFabAlPerm");
            venusenafalperm2["Año"] = "A1";
            venusenafalperm2["Modelo"] = "A1";
            venusenafalperm2["NumPlacas"] = "A1";
            venusenafalperm2["RFC"] = "A1";
            decretoSustit.AgregaSubnodo(venusenafalperm2);
            renysv.AgregaSubnodo(decretoSustit);
            return renysv;
        }

        /// <summary>
        ///Nodo complemento SPEI
        /// </summary>
        public MFObject complementoSPEI()
        {
            MFObject spei = new MFObject("SPEI");
            //Tercero
            MFObject sterceros = new MFObject("SPEI_Tercero");
            MFObject spei0 = new MFObject("0");
            spei0["FechaOperacion"] = "O";
            spei0["Hora"] = "2016-10-31";
            spei0["ClaveSPEI"] = "2016-10-16";
            spei0["sello"] = "2016-10-31";
            spei0["numeroCertificado"] = "15";
            spei0["cadenaCDA"] = "15";
            //Ordenante
            MFObject ordenante = new MFObject("Ordenante");
            ordenante["BancoEmisor"] = "O";
            ordenante["Nombre"] = "O";
            ordenante["TipoCuenta"] = "O";
            ordenante["Cuenta"] = "O";
            ordenante["RFC"] = "O";
            //Beneficiario
            MFObject beneficiario = new MFObject("Beneficiario");
            beneficiario["BancoReceptor"] = "O";
            beneficiario["Nombre"] = "O";
            beneficiario["TipoCuenta"] = "O";
            beneficiario["Cuenta"] = "O";
            beneficiario["RFC"] = "O";
            beneficiario["Concepto"] = "O";
            beneficiario["IVA"] = "O";
            beneficiario["MontoPago"] = "O";
            spei0.AgregaSubnodo(ordenante);
            spei0.AgregaSubnodo(beneficiario);
            sterceros.AgregaSubnodo(spei0);

            MFObject spei1 = new MFObject("1");
            spei1["FechaOperacion"] = "fewO";
            spei1["Hora"] = "2016-10-31";
            spei1["ClaveSPEI"] = "2016-10-16";
            spei1["sello"] = "2016-10-31";
            spei1["numeroCertificado"] = "f15";
            spei1["cadenaCDA"] = "ef15";

            MFObject ordenante2 = new MFObject("Ordenante");
            ordenante2["BancoEmisor"] = "56O";
            ordenante2["Nombre"] = "hytO";
            ordenante2["TipoCuenta"] = "hyO";
            ordenante2["Cuenta"] = "45O";
            ordenante2["RFC"] = "4O";

            MFObject beneficiario2 = new MFObject("Beneficiario");
            beneficiario2["BancoReceptor"] = "hO";
            beneficiario2["Nombre"] = "hfO";
            beneficiario2["TipoCuenta"] = "hfO";
            beneficiario2["Cuenta"] = "hfO";
            beneficiario2["RFC"] = "rwtO";
            beneficiario2["Concepto"] = "kyiuO";
            beneficiario2["IVA"] = "65O";
            beneficiario2["MontoPago"] = "gO";
            spei1.AgregaSubnodo(ordenante2);
            spei1.AgregaSubnodo(beneficiario2);
            sterceros.AgregaSubnodo(spei1);
            spei.AgregaSubnodo(sterceros);
            return spei;
        }

        /// <summary>
        ///Nodo complemento detallista
        /// </summary>
        public MFObject complementoDetallista()
        {
            MFObject detallista = new MFObject("Detallista");
            detallista["documentStatus"] = "COPY";

            MFObject refopaid = new MFObject("requestForPaymentIdentification");
            refopaid["entityType"] = "INVOICE";
            detallista.AgregaSubnodo(refopaid);

            MFObject spins = new MFObject("specialInstruction");
            MFObject spin0 = new MFObject("0");
            spin0["text"] = "hasta15cadenas";
            spin0["text"] = "segunda";
            spin0["code"] = "ZZZ";
            spins.AgregaSubnodo(spin0);
            detallista.AgregaSubnodo(spins);

            MFObject ordid = new MFObject("orderIdentification");
            MFObject references = new MFObject("referenceIdentification");
            MFObject ref0 = new MFObject("0");
            ref0["type"] = "ON";//FIJO
            ordid["ReferenceDate"] = "2016-10-31";
            references.AgregaSubnodo(ref0);
            ordid.AgregaSubnodo(references);
            detallista.AgregaSubnodo(ordid);

            MFObject adinfo = new MFObject("AdditionalInformation");
            MFObject references2 = new MFObject("referenceIdentification");
            MFObject ref02 = new MFObject("0");
            ref02["type"] = "ON";
            references2.AgregaSubnodo(ref02);
            adinfo.AgregaSubnodo(references2);
            detallista.AgregaSubnodo(adinfo);

            MFObject denote = new MFObject("DeliveryNote");
            MFObject references3 = new MFObject("referenceIdentification");
            MFObject ref03 = new MFObject("0");
            ref03["referenceIdentification"] = "hasta30cadenas";
            denote["ReferenceDate"] = "2016-10-31";
            references3.AgregaSubnodo(ref03);
            denote.AgregaSubnodo(references3);
            detallista.AgregaSubnodo(denote);

            MFObject buyer = new MFObject("buyer");
            MFObject contacto = new MFObject("contactInformation");
            MFObject pers = new MFObject("personOrDepartmentName");
            buyer["gln"] = "gthtr";
            pers["text"] = "mitexto";
            contacto.AgregaSubnodo(pers);
            buyer.AgregaSubnodo(contacto);
            detallista.AgregaSubnodo(contacto);

            MFObject seller = new MFObject("seller");
            MFObject altpaid = new MFObject("alternatePartyIdentification");
            seller["gln"] = "yun";
            altpaid["type"] = "IEPS_REFERENCE";
            seller.AgregaSubnodo(altpaid);
            detallista.AgregaSubnodo(seller);

            MFObject shipto = new MFObject("shipTo");
            MFObject infos = new MFObject("nameAndAddress");
            MFObject inf0 = new MFObject("0");
            shipto["gln"] = "kui";
            inf0["name"] = "sergio";
            inf0["streetAddressOne"] = "torre del redentor";
            inf0["city"] = "torreon";
            inf0["postalCode"] = "27000";
            infos.AgregaSubnodo(inf0);
            shipto.AgregaSubnodo(infos);
            detallista.AgregaSubnodo(shipto);

            MFObject invoice = new MFObject("InvoiceCreator");
            MFObject altpaid2 = new MFObject("alternatePartyIdentification");
            MFObject namedir = new MFObject("nameAndAddress");
            invoice["gln"] = "jtyuj";
            altpaid2["type"] = "VA";
            namedir["name"] = "Blanca";
            namedir["streetAddressOne"] = "torre blanca";
            namedir["city"] = "torreon";
            namedir["postalCode"] = "27200";
            invoice.AgregaSubnodo(altpaid2);
            invoice.AgregaSubnodo(namedir);
            detallista.AgregaSubnodo(invoice);

            MFObject clientes = new MFObject("Customs");
            MFObject client0 = new MFObject("0");
            MFObject client1 = new MFObject("1");
            client0["gln"] = "trece";
            client1["gln"] = "dos";
            clientes.AgregaSubnodo(client0);
            clientes.AgregaSubnodo(client1);
            detallista.AgregaSubnodo(clientes);

            MFObject currency = new MFObject("currency");
            MFObject cur0 = new MFObject("0");
            cur0["currencyFunction"] = "BILLING_CURRENCY";
            cur0["currencyFunction"] = "PRICE_CURRENCY";
            cur0["currencyFunction"] = "PAYMENT_CURRENCY";
            cur0["rateOfChange"] = "12.8";
            cur0["currencyISOCode"] = "USD";
            currency.AgregaSubnodo(cur0);
            detallista.AgregaSubnodo(currency);

            MFObject payterms = new MFObject("paymentTerms");
            MFObject paytime = new MFObject("paymentTimePeriod");
            MFObject timePeriod = new MFObject("timePeriodDue");
            timePeriod["value"] = "Ano";
            timePeriod["timePeriod"] = "DAYS";
            MFObject netpay = new MFObject("netPayment");
            MFObject dispay = new MFObject("discountPayment");
            netpay["netPaymentTermsType"] = "DAYS";
            dispay["percentage"] = "1%";
            dispay["discountType"] = "SANCTION";
            payterms["paymentTermsEvent"] = "DATE_OF_INVOICE";
            payterms["PaymentTermsRelationTime"] = "REFERENCE_AFTER";
            paytime.AgregaSubnodo(timePeriod);
            payterms.AgregaSubnodo(paytime);
            payterms.AgregaSubnodo(netpay);
            payterms.AgregaSubnodo(dispay);
            detallista.AgregaSubnodo(payterms);

            detallista["shipmentDetail"] = "LIHHI";
            MFObject allowance = new MFObject("allowanceCharge");
            allowance["allowanceChargeType"] = "ALLOWANCE_GLOBAL";
            allowance["settlementType"] = "BILL_BACK";
            allowance["sequenceNumber"] = "del1al15";
            allowance["specialServicesType"] = "RAA";
            MFObject monetary = new MFObject("monetaryAmountOrPercentage");
            MFObject rate = new MFObject("rate");
            rate["percentage"] = "21.32";
            rate["base"] = "INVOICE_VALUE";
            monetary.AgregaSubnodo(rate);
            allowance.AgregaSubnodo(monetary);
            detallista.AgregaSubnodo(allowance);

            MFObject lineas = new MFObject("lineItem");
            MFObject item = new MFObject("0");
            item["type"] = "SimpleInvoiceLineItemType";
            item["number"] = "123";

            MFObject trade = new MFObject("tradeItemIdentification");
            trade["gtin"] = "btyu";
            item.AgregaSubnodo(trade);
            MFObject altern = new MFObject("alternateTradeItemIdentification");
            MFObject alt0 = new MFObject("0");
            alt0["type"] = "SERIAL_NUMBER";
            altern.AgregaSubnodo(alt0);
            item.AgregaSubnodo(altern);
            MFObject desc = new MFObject("tradeItemDescriptionInformation");
            desc["longText"] = "textolargo";
            desc["language"] = "ES";
            item.AgregaSubnodo(desc);
            MFObject invoqua = new MFObject("invoicedQuantity");
            invoqua["unitOfMeasure"] = "ernyt";
            item.AgregaSubnodo(invoqua);
            MFObject aditional = new MFObject("aditionalQuantity");
            MFObject ad0 = new MFObject("0");
            ad0["QuantityType"] = "FREE_GOODS";
            aditional.AgregaSubnodo(ad0);
            item.AgregaSubnodo(aditional);
            MFObject gross = new MFObject("grossPrice");
            gross["Amount"] = "34.4";
            item.AgregaSubnodo(gross);
            MFObject netprice = new MFObject("netPrice");
            netprice["Amount"] = "23.8";
            item.AgregaSubnodo(netprice);

            MFObject adInformation = new MFObject("AdditionalInformation");
            MFObject reference = new MFObject("referenceIdentification");
            reference["type"] = "ON";
            adInformation.AgregaSubnodo(reference);
            item.AgregaSubnodo(adInformation);
            MFObject customs = new MFObject("Customs");
            MFObject cus0 = new MFObject("0");
            MFObject alt = new MFObject("alternatePartyIdentification");
            cus0["gln"] = "hastatrece";
            alt["type"] = "TN";
            cus0["ReferenceDate"] = "20219";
            cus0["nameAndAddress"] = "SERGIO TORRES";
            cus0.AgregaSubnodo(alt);
            customs.AgregaSubnodo(cus0);
            item.AgregaSubnodo(customs);
            MFObject logic = new MFObject("LogisticUnits");
            MFObject serial = new MFObject("serialShippingContainerCode");
            serial["type"] = "BJ";
            logic.AgregaSubnodo(serial);
            item.AgregaSubnodo(logic);
            MFObject pallet = new MFObject("palletInformation");
            pallet["palletQuantity"] = "PAREG";
            MFObject pdesc = new MFObject("description");
            pdesc["type"] = "BOX";
            MFObject trans = new MFObject("transport");
            trans["methodOfPayment"] = "PAID_BY_BUYER";
            pallet.AgregaSubnodo(pdesc);
            pallet.AgregaSubnodo(trans);
            item.AgregaSubnodo(pallet);
            MFObject extended = new MFObject("extendedAttributes");
            MFObject lotnum = new MFObject("lotNumber");
            MFObject lot0 = new MFObject("0");
            lot0["productionDate"] = "098984";
            lotnum.AgregaSubnodo(lot0);
            extended.AgregaSubnodo(lotnum);
            item.AgregaSubnodo(extended);
            MFObject allows = new MFObject("allowanceCharge");
            MFObject allow0 = new MFObject("0");
            allow0["specialServicesType"] = "VAB";
            MFObject moampe = new MFObject("monetaryAmountOrPercentage");
            moampe["percentagePerUnit"] = "kjhw";
            MFObject rapeun = new MFObject("ratePerUnit");
            rapeun["amountPerUnit"] = "jyu";
            allow0["allowanceChargeType"] = "ALLOWANCE_GLOBAL";
            allow0["settlementType"] = "OFF_INVOICE";
            allow0["sequenceNumber"] = "ntyyu";
            moampe.AgregaSubnodo(rapeun);
            allow0.AgregaSubnodo(moampe);
            allows.AgregaSubnodo(allow0);
            item.AgregaSubnodo(allows);
            MFObject trades = new MFObject("tradeItemTaxInformation");
            MFObject trade0 = new MFObject("0");
            trade0["taxTypeDescription"] = "AAA";
            trade0["referenceNumber"] = "kuhywe";
            MFObject tradeamo = new MFObject("tradeItemTaxAmount");
            tradeamo["taxPercentage"] = "76.12";
            tradeamo["taxAmount"] = "43.6";
            trade0["taxCategory"] = "TRANSFERIDO";
            trade0.AgregaSubnodo(tradeamo);
            trades.AgregaSubnodo(trade0);
            item.AgregaSubnodo(trades);
            MFObject totaline = new MFObject("totalLineAmount");
            MFObject grossa = new MFObject("grossAmount");
            grossa["Amount"] = "65.8";
            MFObject neta = new MFObject("netAmount");
            neta["Amount"] = "63.9";
            totaline.AgregaSubnodo(grossa);
            totaline.AgregaSubnodo(neta);
            item.AgregaSubnodo(totaline);
            lineas.AgregaSubnodo(item);
            detallista.AgregaSubnodo(lineas);
            MFObject totalamo = new MFObject("totalAmount");
            totalamo["Amount"] = "12.3";
            detallista.AgregaSubnodo(totalamo);
            MFObject totalallow = new MFObject("TotalAllowanceCharge");
            MFObject ta0 = new MFObject("0");
            ta0["specialServicesType"] = "ABZ";
            ta0["Amount"] = "54.9";
            ta0["allowanceOrChargeType"] = "ALLOWANCE";
            totalallow.AgregaSubnodo(ta0);
            detallista.AgregaSubnodo(totalallow);
            return detallista;
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void facturaNormalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");
            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";
            factura["total"] = "1160.00";

            MFObject cfdiRelacionados = new MFObject("CfdisRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "XAXX010101000";
            receptor["nombre"] = "Público en general";
            receptor["UsoCFDI"] = "G01";

            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["NoIdentificacion"] = "COD01";
            concepto0["Cantidad"] = "1.00";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Descripcion"] = "Producto de prueba 1";
            concepto0["ValorUnitario"] = "700.00";
            concepto0["Importe"] = "700.00";
            MFObject conimp0 = new MFObject("Impuestos");
            MFObject conimp0tras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "700.00";
            contra0["Importe"] = "112.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["TipoFactor"] = "Tasa";
            conimp0tras.AgregaSubnodo(contra0);
            conimp0.AgregaSubnodo(conimp0tras);
            concepto0.AgregaSubnodo(conimp0);

            MFObject concepto1 = new MFObject("1");
            concepto1["ClaveProdServ"] = "01010101";
            concepto1["NoIdentificacion"] = "COD02";
            concepto1["Cantidad"] = "1.00";
            concepto1["ClaveUnidad"] = "C81";
            concepto1["Descripcion"] = "Producto de prueba 2";
            concepto1["ValorUnitario"] = "300.00";
            concepto1["Importe"] = "300.00";
            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "300.00";
            contra1["Importe"] = "48.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);
            concepto1.AgregaSubnodo(conimp1);

            conceptos.AgregaSubnodo(concepto0);
            conceptos.AgregaSubnodo(concepto1);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "160.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);

            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiNomina12Normal_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "500.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "500.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "500.00";
            concepto0["Importe"] = "500.00";

            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "500.00";
            nomina["TotalDeducciones"] = "250.00";
            nomina["TotalOtrosPagos"] = "0.0";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);

            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "546879213";
            nomina.AgregaSubnodo(nemisor);

            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "250.00";
            npercepciones["TotalExento"] = "250.00";
            npercepciones["TotalSueldos"] = "500.00";

            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "200.00";
            nper0["ImporteExento"] = "250.00";
            MFObject nper1 = new MFObject("1");
            nper1["TipoPercepcion"] = "049";
            nper1["Clave"] = "014";
            nper1["Concepto"] = "Premios de asistencia";
            nper1["ImporteGravado"] = "25.00";
            nper1["ImporteExento"] = "0.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "010";
            nper2["Clave"] = "013";
            nper2["Concepto"] = "Premios por puntualidad";
            nper2["ImporteGravado"] = "25.00";
            nper2["ImporteExento"] = "0.00";
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper1);
            npercepciones.AgregaSubnodo(nper2);
            nomina.AgregaSubnodo(npercepciones);

            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);

            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiAccionesTitulos_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";

            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nemisor["RfcPatronOrigen"] = "LAN7008173R5";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "500.00";
            npercepciones["TotalExento"] = "500.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "abc";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "300.00";
            nper0["ImporteExento"] = "500.00";
            MFObject nper1 = new MFObject("1");
            nper1["TipoPercepcion"] = "002";
            nper1["Clave"] = "def";
            nper1["Concepto"] = "Premios de asistencia";
            nper1["ImporteGravado"] = "50.00";
            nper1["ImporteExento"] = "0.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "045";
            nper2["Clave"] = "ghi";
            nper2["Concepto"] = "Premios por puntualidad";
            nper2["ImporteGravado"] = "150.00";
            nper2["ImporteExento"] = "0.00";
            //acciones de nómina
            MFObject acciones = new MFObject("AccionesOTitulos");
            acciones["ValorMercado"] = "100.00";
            acciones["PrecioAlOtorgarse"] = "150.00";
            nper2.AgregaSubnodo(acciones);
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper1);
            npercepciones.AgregaSubnodo(nper2);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiFiniquito_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "900.00";
            npercepciones["TotalSeparacionIndemnizacion"] = "100.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "800.00";
            nper0["ImporteExento"] = "100.00";
            MFObject nper1 = new MFObject("1");
            nper1["TipoPercepcion"] = "023";
            nper1["Clave"] = "014";
            nper1["Concepto"] = "Separacion";
            nper1["ImporteGravado"] = "100.00";
            nper1["ImporteExento"] = "0.00";
            //Separación indemnización
            MFObject separacion = new MFObject("SeparacionIndemnizacion");
            separacion["TotalPagado"] = "10000.00";
            separacion["NumAñosServicio"] = "3";
            separacion["UltimoSueldoMensOrd"] = "1000.00";
            separacion["IngresoAcumulable"] = "100.00";
            separacion["IngresoNoAcumulable"] = "9000.00";
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper1);
            npercepciones.AgregaSubnodo(separacion);
            nomina.AgregaSubnodo(npercepciones);
            //totsueldos+jubpens+sepindem=totgravado+totexcento
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);

            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiGobierno_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\SDK2\timbrados\cfdi_ejemplo_factura_nomina_gob" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\SDK2\timbrados\sin_timbrar_ejemplo_factura_nomina_gob" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00


            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            //Complemento NominaGobierno
            /*MFObject entidad = new MFObject("EntidadSNCF");
            entidad["OrigenRecurso"] = "IF";
            nemisor.AgregaSubnodo(entidad);*/
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "300.00";
            nper0["ImporteExento"] = "0.00";
            MFObject nper1 = new MFObject("1");
            nper1["TipoPercepcion"] = "049";
            nper1["Clave"] = "014";
            nper1["Concepto"] = "Premios de asistencia";
            nper1["ImporteGravado"] = "300.00";
            nper1["ImporteExento"] = "50.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "010";
            nper2["Clave"] = "013";
            nper2["Concepto"] = "Premios por puntualidad";
            nper2["ImporteGravado"] = "300.00";
            nper2["ImporteExento"] = "50.00";
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper1);
            npercepciones.AgregaSubnodo(nper2);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.0";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiHorasExtra_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "700.00";
            nper0["ImporteExento"] = "100.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "019";
            nper2["Clave"] = "013";
            nper2["Concepto"] = "Horas extra";
            nper2["ImporteGravado"] = "200.00";
            nper2["ImporteExento"] = "0.00";
            //Horas extra
            MFObject horasextra = new MFObject("HorasExtra");
            MFObject hora0 = new MFObject("0");
            hora0["Dias"] = "2";
            hora0["TipoHoras"] = "01";
            hora0["HorasExtra"] = "1";
            hora0["ImportePagado"] = "200.00";
            horasextra.AgregaSubnodo(hora0);
            nper2.AgregaSubnodo(horasextra);
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper2);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nóminas
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiIncapacidad_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "900.00";
            nper0["ImporteExento"] = "100.00";
            npercepciones.AgregaSubnodo(nper0);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);
            // Incapacidades
            MFObject incapacidades = new MFObject("Incapacidades");
            MFObject incapacidad0 = new MFObject("0");
            incapacidad0["DiasIncapacidad"] = "2";
            incapacidad0["TipoIncapacidad"] = "01";
            incapacidad0["ImporteMonetario"] = "300.00";
            incapacidades.AgregaSubnodo(incapacidad0);
            nomina.AgregaSubnodo(incapacidades);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiJubilacion_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "21000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "21000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "21000.00";
            concepto0["Importe"] = "21000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "21000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "20900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            npercepciones["TotalJubilacionPensionRetiro"] = "20000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "900.00";
            nper0["ImporteExento"] = "100.00";
            MFObject nper2 = new MFObject("2");
            nper2["TipoPercepcion"] = "039";
            nper2["Clave"] = "013";
            nper2["Concepto"] = "Jubilacion";
            nper2["ImporteGravado"] = "20000.00";
            nper2["ImporteExento"] = "0.00";
            //Jubilación, pensión, retiro
            MFObject jubilacion = new MFObject("JubilacionPensionRetiro");
            jubilacion["IngresoAcumulable"] = "1000.00";
            jubilacion["IngresoNoAcumulable"] = "3000.00";
            jubilacion["TotalUnaExhibicion"] = "16000.00";
            npercepciones.AgregaSubnodo(nper0);
            npercepciones.AgregaSubnodo(nper2);
            npercepciones.AgregaSubnodo(jubilacion);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nómina
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiSubContratacion_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\SDK2\timbrados\cfdi_ejemplo_factura_nomina_sub" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\SDK2\timbrados\sin_timbrar_ejemplo_factura_nomina_sub" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            //Subcontratación
            MFObject subcontratacion = new MFObject("SubContratacion");
            MFObject subcontratacion0 = new MFObject("0");
            subcontratacion0["RfcLabora"] = "VOC990129I26";
            subcontratacion0["PorcentajeTiempo"] = "100.00";
            subcontratacion.AgregaSubnodo(subcontratacion0);
            nreceptor.AgregaSubnodo(subcontratacion);
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "900.00";
            nper0["ImporteExento"] = "100.00";
            npercepciones.AgregaSubnodo(nper0);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nóminas
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiSubsidio_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "nomina12");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_nomina" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "99";
            factura["tipocomprobante"] = "N";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "6000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "6000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111505";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago de nómina";
            concepto0["ValorUnitario"] = "6000.00";
            concepto0["Importe"] = "6000.00";
            conceptos.AgregaSubnodo(concepto0);

            MFObject nomina = new MFObject("nomina12");
            nomina["TipoNomina"] = "O";
            nomina["FechaPago"] = "2016-10-31";
            nomina["FechaInicialPago"] = "2016-10-16";
            nomina["FechaFinalPago"] = "2016-10-31";
            nomina["NumDiasPagados"] = "15";
            nomina["TotalPercepciones"] = "1000.00";
            nomina["TotalDeducciones"] = "250.00";
            nomina["TotalOtrosPagos"] = "5000.00";
            //receptor de nómina
            MFObject nreceptor = new MFObject("Receptor");
            nreceptor["ClaveEntFed"] = "JAL";
            nreceptor["Curp"] = "CACF880922HJCMSR03";
            nreceptor["NumEmpleado"] = "060";
            nreceptor["PeriodicidadPago"] = "04";
            nreceptor["TipoContrato"] = "01";
            nreceptor["TipoRegimen"] = "02";
            nreceptor["Antigüedad"] = "P21W";
            nreceptor["Banco"] = "021";
            nreceptor["CuentaBancaria"] = "1234567890";
            nreceptor["FechaInicioRelLaboral"] = "2016-06-01";
            nreceptor["NumSeguridadSocial"] = "04078873454";
            nreceptor["Puesto"] = "Desarrollador";
            nreceptor["RiesgoPuesto"] = "2";
            nreceptor["SalarioBaseCotApor"] = "435.50";
            nreceptor["SalarioDiarioIntegrado"] = "435.50";
            nomina.AgregaSubnodo(nreceptor);
            //emisor de nómina
            MFObject nemisor = new MFObject("Emisor");
            nemisor["RegistroPatronal"] = "5525665412";
            nomina.AgregaSubnodo(nemisor);
            //percepciones de nómina
            MFObject npercepciones = new MFObject("Percepciones");
            npercepciones["TotalGravado"] = "900.00";
            npercepciones["TotalExento"] = "100.00";
            npercepciones["TotalSueldos"] = "1000.00";
            MFObject nper0 = new MFObject("0");
            nper0["TipoPercepcion"] = "001";
            nper0["Clave"] = "001";
            nper0["Concepto"] = "Sueldos, Salarios Rayas y Jornales";
            nper0["ImporteGravado"] = "900.00";
            nper0["ImporteExento"] = "100.00";
            npercepciones.AgregaSubnodo(nper0);
            nomina.AgregaSubnodo(npercepciones);
            //deducciones de nóminas
            MFObject ndeducciones = new MFObject("Deducciones");
            ndeducciones["TotalOtrasDeducciones"] = "150.00";
            ndeducciones["TotalImpuestosRetenidos"] = "100.00";
            MFObject nded0 = new MFObject("0");
            nded0["TipoDeduccion"] = "002";
            nded0["Clave"] = "001";
            nded0["Concepto"] = "ISR";
            nded0["Importe"] = "100.00";
            MFObject nded1 = new MFObject("1");
            nded1["TipoDeduccion"] = "001";
            nded1["Clave"] = "012";
            nded1["Concepto"] = "Seguridad social";
            nded1["Importe"] = "150.00";
            ndeducciones.AgregaSubnodo(nded0);
            ndeducciones.AgregaSubnodo(nded1);
            nomina.AgregaSubnodo(ndeducciones);
            //Otros pagos
            MFObject pagos = new MFObject("OtrosPagos");
            MFObject pago0 = new MFObject("0");
            pago0["TipoOtroPago"] = "002";
            pago0["Clave"] = "012";
            pago0["Concepto"] = "Subsidio para el empleo";
            pago0["Importe"] = "5000.00";
            //Subsidio al empleo
            MFObject subsidio = new MFObject("SubsidioAlEmpleo");
            subsidio["SubsidioCausado"] = "5000.00";

            //Compensación saldos a favor
            MFObject compensacion = new MFObject("CompensacionSaldosAFavor");
            compensacion["SaldoAFavor"] = "300.00";
            compensacion["Año"] = "2016";
            compensacion["RemanenteSalFav"] = "100.00";
            pago0.AgregaSubnodo(compensacion);
            pago0.AgregaSubnodo(subsidio);
            pagos.AgregaSubnodo(pago0);
            nomina.AgregaSubnodo(pagos);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(nomina);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void escuelaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "iedu10");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_escuela" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_escuela" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["Cantidad"] = "1";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Unidad"] = "NO APLICA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "MENSUALIDAD ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "0.00";
            //impuestos["TotalImpuestosRetenidos"] = "0.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "003";
            itra0["Importe"] = "0.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            // Retenciones
            MFObject irets = new MFObject("retenidos");
            MFObject iret0 = new MFObject("0");
            iret0["Impuesto"] = "002";
            iret0["Importe"] = "0.00";
            MFObject iret1 = new MFObject("1");
            iret1["Impuesto"] = "001";
            iret1["Importe"] = "0.00";
            irets.AgregaSubnodo(iret0);
            irets.AgregaSubnodo(iret1);
            impuestos.AgregaSubnodo(irets);

            // IEDU
            MFObject iedu = new MFObject("IEDU");
            iedu["nombreAlumno"] = "FULANITO PEREZ OCHOA";
            iedu["CURP"] = "MAGC870912HGTRRS06";
            iedu["nivelEducativo"] = "Preescolar";
            iedu["autRVOE"] = "1234-ABC";
            iedu["RFCPago"] = "SOHM7509289MA";

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(iedu);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void parcialidadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_parcialidades" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_parcialidades" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PPD";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "100.00";
            factura["total"] = "116.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "NO APLICA";
            concepto0["ClaveUnidad"] = "A90";
            concepto0["descripcion"] = "COBRO PARCIALIDAD DE VENTA A90";
            concepto0["valorunitario"] = "100.00";
            concepto0["importe"] = "100.00";

            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "100.00";
            contra1["Importe"] = "16.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);
            concepto0.AgregaSubnodo(conimp1);

            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "16.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "16.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void arrendamientoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_arrendamiento" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_arrendamiento" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "100.00";
            factura["total"] = "84.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "NO APLICA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "RENTA DE OFICINA MAYO 2014";
            concepto0["valorunitario"] = "100.00";
            concepto0["importe"] = "100.00";

            MFObject predial = new MFObject("CuentaPredial");
            predial["Numero"] = "12345678";
            concepto0.AgregaSubnodo(predial);

            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "100.00";
            contra1["Importe"] = "16.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);

            MFObject conimp1rets = new MFObject("Retenciones");
            MFObject conret1 = new MFObject("0");
            conret1["Base"] = "100.00";
            conret1["Importe"] = "16.00";
            conret1["Impuesto"] = "002";
            conret1["TasaOCuota"] = "0.160000";
            conret1["TipoFactor"] = "Tasa";
            conimp1rets.AgregaSubnodo(conret1);

            MFObject conret2 = new MFObject("1");
            conret2["Base"] = "100.00";
            conret2["Importe"] = "16.00";
            conret2["Impuesto"] = "001";
            conret2["TasaOCuota"] = "0.160000";
            conret2["TipoFactor"] = "Tasa";
            conimp1rets.AgregaSubnodo(conret2);
            conimp1.AgregaSubnodo(conimp1rets);

            concepto0.AgregaSubnodo(conimp1);

            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "16.00";
            impuestos["TotalImpuestosRetenidos"] = "32.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "16.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);

            MFObject irets = new MFObject("retenciones");
            MFObject ret0 = new MFObject("0");
            ret0["Impuesto"] = "002";
            ret0["Importe"] = "16.00";
            MFObject ret1 = new MFObject("1");
            ret1["Impuesto"] = "001";
            ret1["Importe"] = "16.00";
            irets.AgregaSubnodo(ret0);
            irets.AgregaSubnodo(ret1);
            impuestos.AgregaSubnodo(itras);
            impuestos.AgregaSubnodo(irets);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void chequeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_cheque.xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_cheque.xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");
            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "02";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";
            factura["total"] = "1160.00";

            MFObject cfdiRelacionados = new MFObject("CfdisRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "XAXX010101000";
            receptor["nombre"] = "Público en general";
            receptor["UsoCFDI"] = "G01";

            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["NoIdentificacion"] = "COD01";
            concepto0["Cantidad"] = "1.00";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Descripcion"] = "Producto de prueba 1";
            concepto0["ValorUnitario"] = "700.00";
            concepto0["Importe"] = "700.00";
            MFObject conimp0 = new MFObject("Impuestos");
            MFObject conimp0tras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "700.00";
            contra0["Importe"] = "112.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["TipoFactor"] = "Tasa";
            conimp0tras.AgregaSubnodo(contra0);
            conimp0.AgregaSubnodo(conimp0tras);
            concepto0.AgregaSubnodo(conimp0);

            MFObject concepto1 = new MFObject("1");
            concepto1["ClaveProdServ"] = "01010101";
            concepto1["NoIdentificacion"] = "COD02";
            concepto1["Cantidad"] = "1.00";
            concepto1["ClaveUnidad"] = "C81";
            concepto1["Descripcion"] = "Producto de prueba 2";
            concepto1["ValorUnitario"] = "300.00";
            concepto1["Importe"] = "300.00";
            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "300.00";
            contra1["Importe"] = "48.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);
            concepto1.AgregaSubnodo(conimp1);

            conceptos.AgregaSubnodo(concepto0);
            conceptos.AgregaSubnodo(concepto1);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "160.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);

            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void cancelarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ejemplo_cancela_factura();
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void notarioPublicoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "notariospublicos10");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_notarios" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_notarios" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Cantidad"] = "1";
            concepto0["Unidad"] = "PIEZA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "MENSUALIDAD ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            // Notario Publico
            MFObject notario = new MFObject("notariospublicos10");
            MFObject datos = new MFObject("DatosNotario");
            datos["CURP"] = "AAQM010101HCSMNZ00";
            datos["NumNotaria"] = "3";
            datos["EntidadFederativa"] = "16";
            datos["Adscripcion"] = "Guanajuato";
            notario.AgregaSubnodo(datos);
            // Descripcion de inmuebles
            MFObject inmuebles = new MFObject("DescInmuebles");
            MFObject inmueble0 = new MFObject("0");
            inmueble0["Calle"] = "Av. Siempre Viva";
            inmueble0["CodigoPostal"] = "12345";
            inmueble0["Colonia"] = "Bondojito";
            inmueble0["Estado"] = "14";
            inmueble0["Localidad"] = "Oaxaca";
            inmueble0["Municipio"] = "Oaxaca";
            inmueble0["NoExterior"] = "123";
            inmueble0["NoInterior"] = "B";
            inmueble0["Pais"] = "MEX";
            inmueble0["TipoInmueble"] = "01";
            inmuebles.AgregaSubnodo(inmueble0);
            notario.AgregaSubnodo(inmuebles);
            //Datos de operación
            MFObject datosOperacion = new MFObject("DatosOperacion");
            datosOperacion["NumInstrumentoNotarial"] = "12345";
            datosOperacion["FechaInstNotarial"] = "2014-04-22";
            datosOperacion["MontoOperacion"] = "1234.56";
            datosOperacion["Subtotal"] = "1234.56";
            datosOperacion["IVA"] = "1234.56";
            notario.AgregaSubnodo(datosOperacion);

            /* Datos de Varios Enajenantes
            MFObject enajenantes = new MFObject("NotariosPublicos.DatosEnajenantesCopSC");
            MFObject enajenante0 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.0");
            enajenante0["Nombre"] = "Enajenante 1";
            enajenante0["ApellidoPaterno"] = "Apellido Paterno";
            enajenante0["ApellidoMaterno"] = "Apellido Materno";
            enajenante0["RFC"] = "HSJ600903MN0";
            enajenante0["CURP"] = "OAAJ840102HJCVRN00";
            enajenante0["Porcentaje"] = "50";
            enajenantes.AgregaSubnodo(enajenante0);

            MFObject enajenante1 = new MFObject("NotariosPublicos.DatosEnajenantesCopSC.1");
            enajenante1["Nombre"] = "Enajenante 2";
            enajenante1["ApellidoPaterno"] = "Apellido Paterno";
            enajenante1["ApellidoMaterno"] = "Apellido Materno";
            enajenante1["RFC"] = "MSB600304KL9";
            enajenante1["CURP"] = "OAAJ840102HJCVRN00";
            enajenante1["Porcentaje"] = "50";
            enajenantes.AgregaSubnodo(enajenante1);

            DatosEnajenante datosEnajenante = new DatosEnajenante();
            datosEnajenante.CoproSocConyugalE = "Si";
            datosEnajenante.DatosEnajenanteCopSC = enajenantes;
            */
            // Datos para un Solo Enajenante
            MFObject unenajenante = new MFObject("DatosUnEnajenante");
            unenajenante["Nombre"] = "Enajenante";
            unenajenante["ApellidoPaterno"] = "Apellido Paterno";
            unenajenante["ApellidoMaterno"] = "Apellido Materno";
            unenajenante["RFC"] = "HSJ600903MN0";
            unenajenante["CURP"] = "OAAJ840102HJCVRN00";

            MFObject datosEnajenante = new MFObject("DatosEnajenante");
            datosEnajenante["CoproSocConyugalE"] = "No";
            datosEnajenante.AgregaSubnodo(unenajenante);
            notario.AgregaSubnodo(datosEnajenante);

            /* Datos de Varios Adquirientes
            MFObject adquirientes = new MFObject("DatosAdquirientesCopSC");
            MFObject adquiriente0 = new MFObject("0");
            adquiriente0["Nombre"] = "Adquiriente 1";
            adquiriente0["ApellidoPaterno"] = "Apellido Paterno";
            adquiriente0["ApellidoMaterno"] = "Apellido Materno";
            adquiriente0["RFC"] = "HSJ600903MN0";
            adquiriente0["CURP"] = "OAAJ840102HJCVRN00";
            adquiriente0["Porcentaje"] = "50";
            adquirientes.AgregaSubnodo(adquiriente0);

            MFObject adquiriente1 = new MFObject("1");
            adquiriente1["Nombre"] = "Adquiriente 2";
            adquiriente1["ApellidoPaterno"] = "Apellido Paterno";
            adquiriente1["ApellidoMaterno"] = "Apellido Materno";
            adquiriente1["RFC"] = "MSB600304KL9";
            adquiriente1["CURP"] = "OAAJ840102HJCVRN00";
            adquiriente1["Porcentaje"] = "50";
            adquirientes.AgregaSubnodo(adquiriente1);

            MFObject datosAdquiriente = new MFObject("DatosAdquiriente");
            datosAdquiriente["CoproSocConyugalE"] = "Si";
            datosAdquiriente.AgregaSubnodo(adquirientes);
            notario.AgregaSubnodo(datosAdquiriente);
            */

            // Datos un Solo Adquiriente
            MFObject unadquiriente = new MFObject("DatosUnAdquiriente");
            unadquiriente["Nombre"] = "Adquiriente";
            unadquiriente["ApellidoPaterno"] = "Apellido Paterno";
            unadquiriente["ApellidoMaterno"] = "Apellido Materno";
            unadquiriente["RFC"] = "HSJ600903MN0";
            unadquiriente["CURP"] = "OAAJ840102HJCVRN00";

            MFObject datosAdquiriente = new MFObject("DatosAdquiriente");
            datosAdquiriente["CoproSocConyugalE"] = "No";
            datosAdquiriente.AgregaSubnodo(unadquiriente);
            notario.AgregaSubnodo(datosAdquiriente);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            //sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(notario);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void doralesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_cheque.xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_cheque.xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");
            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "USD";
            factura["tipocambio"] = "18.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";
            factura["total"] = "1160.00";

            MFObject cfdiRelacionados = new MFObject("CfdisRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "XAXX010101000";
            receptor["nombre"] = "Público en general";
            receptor["UsoCFDI"] = "G01";

            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["NoIdentificacion"] = "COD01";
            concepto0["Cantidad"] = "1.00";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Descripcion"] = "Producto de prueba 1";
            concepto0["ValorUnitario"] = "700.00";
            concepto0["Importe"] = "700.00";
            MFObject conimp0 = new MFObject("Impuestos");
            MFObject conimp0tras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "700.00";
            contra0["Importe"] = "112.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["TipoFactor"] = "Tasa";
            conimp0tras.AgregaSubnodo(contra0);
            conimp0.AgregaSubnodo(conimp0tras);
            concepto0.AgregaSubnodo(conimp0);

            MFObject concepto1 = new MFObject("1");
            concepto1["ClaveProdServ"] = "01010101";
            concepto1["NoIdentificacion"] = "COD02";
            concepto1["Cantidad"] = "1.00";
            concepto1["ClaveUnidad"] = "C81";
            concepto1["Descripcion"] = "Producto de prueba 2";
            concepto1["ValorUnitario"] = "300.00";
            concepto1["Importe"] = "300.00";
            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "300.00";
            contra1["Importe"] = "48.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);
            concepto1.AgregaSubnodo(conimp1);

            conceptos.AgregaSubnodo(concepto0);
            conceptos.AgregaSubnodo(concepto1);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "160.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);

            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void hotelesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "hoteles");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_hoteles" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_hoteles" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Unidad"] = "NO APLICA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "SERVICIO DE HOSPEDAJE 10 AL 25 ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            //Hoteles
            // Impuestos Locales
            MFObject locales = new MFObject("ImpuestosLocales");
            locales["TotaldeRetenciones"] = "0.0";
            locales["TotaldeTraslados"] = "10.0";
            MFObject trasLocales = new MFObject("TrasladoLocal");
            MFObject trasLocal0 = new MFObject("0");
            trasLocal0["ImpLocTrasladado"] = "ISH";
            trasLocal0["Importe"] = "10.00";
            trasLocal0["TasadeTraslado"] = "0.03";
            trasLocales.AgregaSubnodo(trasLocal0);
            locales.AgregaSubnodo(trasLocales);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            //sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(locales);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tercerosToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "terceros11");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_terceros" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_terceros" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Cantidad"] = "1";
            concepto0["Unidad"] = "PIEZA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "MENSUALIDAD ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "0.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "0.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            MFObject terceros = new MFObject("terceros11");
            terceros["rfc"] = "SOHM7509289MA";
            terceros["nombre"] = "maria";
            //Domicilio
            MFObject domTercero = new MFObject("InformacionFiscalTercero");
            domTercero["Calle"] = "JUAREZ";
            domTercero["CodigoPostal"] = "64610";
            domTercero["Estado"] = "NUEVO LEON";
            domTercero["Municipio"] = "MONTERREY";
            domTercero["Localidad"] = "MONTERREY";
            domTercero["Pais"] = "MEXICO";
            domTercero["NoExterior"] = "7";
            domTercero["NoInterior"] = "A";
            domTercero["Colonia"] = "DEL VALLE";
            domTercero["referencia"] = "nuirenfuf";
            terceros.AgregaSubnodo(domTercero);
            //Informaciñon aduanera
            MFObject info = new MFObject("InformacionAduanera");
            info["numero"] = "2331";
            info["fecha"] = "2016-10-31";
            info["aduana"] = "miaduana";
            terceros.AgregaSubnodo(info);
            //Partes
            MFObject partes = new MFObject("Parte");
            MFObject part0 = new MFObject("0");
            part0["cantidad"] = "1";
            part0["unidad"] = "pieza";
            part0["noIdentificacion"] = "56";
            part0["descripcion"] = "56vs";
            part0["valorUnitario"] = "1000";
            part0["importe"] = "1000";
            MFObject p0infos = new MFObject("InformacionAduanera");
            MFObject p0info0 = new MFObject("0");
            p0info0["numero"] = "15";
            p0info0["fecha"] = "2017-05-25";
            p0info0["aduana"] = "56vs";
            p0infos.AgregaSubnodo(p0info0);
            part0.AgregaSubnodo(p0infos);
            partes.AgregaSubnodo(part0);
            terceros.AgregaSubnodo(partes);
            //Cuenta predial
            MFObject predial = new MFObject("CuentaPredial");
            predial["numero"] = "56";
            terceros.AgregaSubnodo(predial);
            //Impuestos
            MFObject impuestos2 = new MFObject("Impuestos");
            MFObject retenciones = new MFObject("Retenciones");
            MFObject ret0 = new MFObject("0");
            ret0["impuesto"] = "001";
            ret0["importe"] = "0.00";
            MFObject traslados = new MFObject("Traslados");
            MFObject tra0 = new MFObject("0");
            tra0["impuesto"] = "003";
            tra0["tasa"] = "0.16";
            tra0["importe"] = "0.00";
            retenciones.AgregaSubnodo(ret0);
            traslados.AgregaSubnodo(tra0);
            impuestos2.AgregaSubnodo(retenciones);
            impuestos2.AgregaSubnodo(traslados);
            terceros.AgregaSubnodo(impuestos2);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(terceros);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void impuestosLocalesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "implocal10");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_impuestos_locales" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_impuestos_locales" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1160.00";//100.00

            MFObject emisor = new MFObject("emisor");
            //emisor["rfc"] = "LAN7008173R5";
            //emisor["nombre"] = "General";
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Unidad"] = "NA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "MENSUALIDAD ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            MFObject conimp1 = new MFObject("Impuestos");
            MFObject conimp1tras = new MFObject("Traslados");
            MFObject contra1 = new MFObject("0");
            contra1["Base"] = "1000.00";
            contra1["Importe"] = "160.00";
            contra1["Impuesto"] = "002";
            contra1["TasaOCuota"] = "0.160000";
            contra1["TipoFactor"] = "Tasa";
            conimp1tras.AgregaSubnodo(contra1);
            conimp1.AgregaSubnodo(conimp1tras);
            concepto0.AgregaSubnodo(conimp1);
            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "160.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            // Impuestos Locales
            MFObject locales = new MFObject("implocal10");
            locales["TotaldeRetenciones"] = "10";
            locales["TotaldeTraslados"] = "10";
            MFObject retLocales = new MFObject("RetencionesLocales");
            MFObject retLocal0 = new MFObject("0");
            retLocal0["ImpLocRetenido"] = "10";
            retLocal0["TasadeRetencion"] = "10";
            retLocal0["Importe"] = "10";
            /*MFObject retLocal1 = new MFObject("1");
            retLocal1["ImpLocTrasladado"] = "DEF";
            retLocal1["TasadeTraslado"] = "3";
            retLocal1["Importe"] = "13";*/
            retLocales.AgregaSubnodo(retLocal0);
            //retLocales.AgregaSubnodo(retLocal1);
            MFObject trasLocales = new MFObject("TrasladosLocales");
            MFObject trasLocal0 = new MFObject("0");
            trasLocal0["ImpLocTrasladado"] = "10";
            trasLocal0["TasadeTraslado"] = "10";
            trasLocal0["Importe"] = "10";
            /*MFObject trasLocal1 = new MFObject("1");
            trasLocal1["ImpLocTrasladado"] = "ASD";
            trasLocal1["TasadeTraslado"] = "3";
            trasLocal1["Importe"] = "10";*/
            trasLocales.AgregaSubnodo(trasLocal0);
            //trasLocales.AgregaSubnodo(trasLocal1);
            locales.AgregaSubnodo(retLocales);
            locales.AgregaSubnodo(trasLocales);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(locales);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void comercioExteriorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "comercioexterior11");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_comercio_exterior" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_comercio_exterior" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "300.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "300.00";//100.00

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");

            for (int i = 0; i <= 2; i++)
            {
                MFObject concepto = new MFObject(i.ToString());
                concepto["ClaveProdServ"] = "01010101";
                concepto["ClaveUnidad"] = "C81";
                concepto["Cantidad"] = "1";
                concepto["Unidad"] = "PIEZA";
                concepto["NoIdentificacion"] = "COD" + (i + 1).ToString();
                concepto["Descripcion"] = "Producto de prueba " + (i + 1).ToString();
                concepto["ValorUnitario"] = "100.00";
                concepto["Importe"] = "100.00";
                conceptos.AgregaSubnodo(concepto);
            }

            MFObject comercio = new MFObject("comercioexterior11");
            comercio["TipoOperacion"] = "2";
            comercio["ClaveDePedimento"] = "A1";
            comercio["CertificadoOrigen"] = "0";
            //comercio["NumeroExportadorConfiable"] = "0";
            comercio["Incoterm"] = "FOB";
            comercio["Subdivision"] = "0";
            //comercio["Observaciones"] = "detalles";
            comercio["TipoCambioUSD"] = "20.00";
            comercio["TotalUSD"] = "15.00";
            //Emisor de comercio
            MFObject cemisor = new MFObject("Emisor");
            //creceptor["Curp"] = "BAJS721028MDFMTR05";
            MFObject emi_dom = new MFObject("Domicilio");
            emi_dom["Calle"] = "Hidalgo";
            emi_dom["NumeroExterior"] = "1000";
            emi_dom["Colonia"] = "0209";
            //emi_dom["Localidad"] = "11";
            //emi_dom["Referencia"] = "str1234";
            emi_dom["Municipio"] = "014";
            emi_dom["Estado"] = "QUE";
            emi_dom["Pais"] = "MEX";
            emi_dom["CodigoPostal"] = "76224";
            cemisor.AgregaSubnodo(emi_dom);
            comercio.AgregaSubnodo(cemisor);
            //Receptor de comercio
            MFObject creceptor = new MFObject("Receptor");
            //creceptor["Curp"] = "HEUJ880222HOCTRR04";
            //creceptor["NumRegIdTrib"] = "123456789";
            MFObject rec_dom = new MFObject("Domicilio");
            rec_dom["Calle"] = "Avenue Sahara";
            rec_dom["NumeroExterior"] = "74";
            rec_dom["Colonia"] = "BIG DESERT";
            //rec_dom["Localidad"] = "11";
            //rec_dom["Referencia"] = "str1234";
            //rec_dom["Municipio"] = "035";
            rec_dom["Estado"] = "NV";
            rec_dom["Pais"] = "USA";
            rec_dom["CodigoPostal"] = "45678";
            creceptor.AgregaSubnodo(rec_dom);
            comercio.AgregaSubnodo(creceptor);
            /*Destinatario de comercio
            MFObject cdestinatario = new MFObject("Destinatario");
            cdestinatario["NumRegIdTrib"] = "123456789";
            cdestinatario["Rfc"] = "ESI920427886";
            cdestinatario["Curp"] = "HIOK800212HOCTRR01";
            cdestinatario["Nombre"] = "str1234";
            //Domicilio
            MFObject domicilio = new MFObject("Domicilio");
            domicilio["Calle"] = "calle de pruebas";
            domicilio["NumeroExterior"] = "1234";
            domicilio["Colonia"] = "0995";
            domicilio["Localidad"] = "11";
            domicilio["Referencia"] = "str1234";
            domicilio["Municipio"] = "035";
            domicilio["Estado"] = "COA";
            domicilio["Pais"] = "MEX";
            domicilio["CodigoPostal"] = "27000";
            cdestinatario.AgregaSubnodo(domicilio);
            comercio.AgregaSubnodo(cdestinatario);*/
            //Mercancías
            MFObject mercancias = new MFObject("Mercancias");
            MFObject merc0 = new MFObject("0");
            merc0["NoIdentificacion"] = "COD1";
            merc0["FraccionArancelaria"] = "94059102";
            merc0["CantidadAduana"] = "1";
            merc0["UnidadAduana"] = "01";
            merc0["ValorUnitarioAduana"] = "5.00";
            merc0["ValorDolares"] = "5.00";
            MFObject merc1 = new MFObject("1");
            merc1["NoIdentificacion"] = "COD2";
            merc1["FraccionArancelaria"] = "94059103";
            merc1["CantidadAduana"] = "1";
            merc1["UnidadAduana"] = "01";
            merc1["ValorUnitarioAduana"] = "5.00";
            merc1["ValorDolares"] = "5.00";
            MFObject merc2 = new MFObject("2");
            merc2["NoIdentificacion"] = "COD3";
            merc2["FraccionArancelaria"] = "94059104";
            merc2["CantidadAduana"] = "1";
            merc2["UnidadAduana"] = "01";
            merc2["ValorUnitarioAduana"] = "5.00";
            merc2["ValorDolares"] = "5.00";
            /*Descripciones
            MFObject descs = new MFObject("DescripcionesEspecificas");
            MFObject desc0 = new MFObject("0");
            desc0["Marca"] = "YAMAHA";
            desc0["Modelo"] = "DDA - 21";
            desc0["SubModelo"] = "DDD1";
            desc0["NumeroSerie"] = "3292383823";
            MFObject desc1 = new MFObject("1");
            desc1["Marca"] = "str12342";
            desc1["Modelo"] = "str12342";
            desc1["SubModelo"] = "str12342";
            desc1["NumeroSerie"] = "3292383823";
            descs.AgregaSubnodo(desc0);
            descs.AgregaSubnodo(desc1);
            merc0.AgregaSubnodo(descs);*/
            mercancias.AgregaSubnodo(merc0);
            mercancias.AgregaSubnodo(merc1);
            mercancias.AgregaSubnodo(merc2);
            comercio.AgregaSubnodo(mercancias);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(comercio);
            // Muestras la estructura
            MostrarDatos(sdk);
        }
        //Los iniciales representan campos de configuración que van al inicio de la factura, puede modificar el nombre de los xml a generar, la versión, etc.
        //Después se agrega crean los nodos de la factura y sus campos, se agregan al sdk y se crea el árbol con los datos con el método MuestraDatos()
        private void tsmiINE_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();

            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "ine11");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_ine" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_ine" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["subtotal"] = "1000.00";//100.00
            factura["descuento"] = "0.00";
            factura["total"] = "1000.00";//100.00

            MFObject cfdiRelacionados = new MFObject("CfdiRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Cantidad"] = "1";
            concepto0["Unidad"] = "PIEZA";
            concepto0["NoIdentificacion"] = "COD1";
            concepto0["Descripcion"] = "MENSUALIDAD ENERO 2014";
            concepto0["ValorUnitario"] = "1000.00";
            concepto0["Importe"] = "1000.00";
            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "0.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "0.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            MFObject ine = new MFObject("ine11");
            ine["TipoProceso"] = "Campaña";
            MFObject entidad = new MFObject("Entidad");
            MFObject entidad0 = new MFObject("0");
            entidad0["ClaveEntidad"] = "TAM";
            entidad0["Ambito"] = "Local";

            MFObject conta = new MFObject("Contabilidad");
            MFObject conta0 = new MFObject("0");
            conta0["IdContabilidad"] = "010648";
            conta.AgregaSubnodo(conta0);
            entidad0.AgregaSubnodo(conta);
            entidad.AgregaSubnodo(entidad0);
            ine.AgregaSubnodo(entidad);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(ine);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void cancelarConAcuseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("complemento", "pagos10");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\SDK2\timbrados\ejemplo_factura_pagos10.xml");
            sdk.Iniciales.Add("xml_debug", @"C:\SDK2\timbrados\debug_ejemplo_pagos10.xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject fact = new MFObject("factura");
            fact["serie"] = "F";
            fact["folio"] = "123";
            fact["fecha_expedicion"] = DateTime.Now.ToString("s");
            fact["tipocomprobante"] = "P";
            fact["moneda"] = "XXX";
            fact["LugarExpedicion"] = "27000";
            fact["subtotal"] = "0";
            fact["total"] = "0";

            MFObject emi = new MFObject("emisor");
            emi["rfc"] = "LAN7008173R5";
            emi["nombre"] = "CINDEMEX SA DE CV";
            emi["RegimenFiscal"] = "601";

            MFObject recept = new MFObject("receptor");
            recept["rfc"] = "SOHM7509289MA";
            recept["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            recept["UsoCFDI"] = "P01";

            //Concepto Normal
            MFObject concepts = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["Cantidad"] = "1";
            concepto0["Descripcion"] = "Pago";
            concepto0["ValorUnitario"] = "0";
            concepto0["Importe"] = "0";
            concepts.AgregaSubnodo(concepto0);

            //Complemento pagos
            MFObject Pagos10 = new MFObject("pagos10");
            MFObject Pagos = new MFObject("Pagos");
            MFObject pago0 = new MFObject("0");
            pago0["FechaPago"] = "2017-09-15T11:07:38";
            pago0["FormaDePagoP"] = "01";
            pago0["MonedaP"] = "MXN";
            pago0["Monto"] = "1740.00";
            //Doctos relacionados
            MFObject doctos = new MFObject("DoctoRelacionado");
            MFObject docto0 = new MFObject("0");
            docto0["IdDocumento"] = "2F28D750-688A-43C3-8004-E103086E1D78";
            docto0["Serie"] = "F";
            docto0["Folio"] = "234";
            docto0["MonedaDR"] = "MXN";
            docto0["MetodoDePagoDR"] = "PPD";
            docto0["NumParcialidad"] = "1";
            docto0["ImpSaldoAnt"] = "1740.00";
            docto0["ImpPagado"] = "1740.00";
            docto0["ImpSaldoInsoluto"] = "0.00";
            doctos.AgregaSubnodo(docto0);
            pago0.AgregaSubnodo(doctos);
            Pagos.AgregaSubnodo(pago0);
            Pagos10.AgregaSubnodo(Pagos);
            /*Impuestos
            MFObject impuestos = new MFObject("Impuestos");
            MFObject imp0 = new MFObject("0");
            imp0["TotalImpuestosRetenidos"] = "0.0";
            imp0["TotalImpuestosTrasladados"] = "0.0";
            MFObject traslados = new MFObject("Traslados");
            MFObject tras0 = new MFObject("0");
            MFObject retenciones = new MFObject("Retenciones");
            MFObject ret0 = new MFObject("0");
            tras0["Impuesto"] = "0.0";
            tras0["Importe"] = "0.0";
            tras0["TipoFactor"] = "0.0";
            tras0["TasaOCuota"] = "0.0";
            ret0["Importe"] = "0.0";
            ret0["Impuesto"] = "0.0";
            traslados.AgregaSubnodo(tras0);
            retenciones.AgregaSubnodo(ret0);
            imp0.AgregaSubnodo(traslados);
            imp0.AgregaSubnodo(retenciones);
            impuestos.AgregaSubnodo(imp0);
            pago0.AgregaSubnodo(impuestos);
            Pagos.AgregaSubnodo(pago0);
            Pagos10.AgregaSubnodo(Pagos);*/
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(fact);
            sdk.AgregaObjeto(emi);
            sdk.AgregaObjeto(recept);
            sdk.AgregaObjeto(concepts);
            sdk.AgregaObjeto(Pagos10);
            //Muestras la estructura
            MostrarDatos(sdk);
        }

        private void consultarSaldoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ejemplo_consulta_saldo();
        }

        private void timbrarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Para agregar varios conceptos con FOR ver ejemplo de Comercio Exterior
            // Se timbra el CFDI
            SDKRespuesta respuesta = sdk.Timbrar(@"C:\sdk2\timbrar32.bat", @"C:\sdk2\timbrados\", "factura", false);
            //Muestra el archivo ini
            textBox1.Text = sdk.Ini;
            //Muestra la respuesta de timbrado
            textBox2.Text = respuesta.RespuestaOriginalSDK;
            // Se notifica que el SDK se ejecutó
            string mensaje = string.Format("Código: {0}\r\nMensaje: {1}", respuesta.Codigo_MF_Numero, respuesta.Codigo_MF_Texto);
            MessageBox.Show(this, mensaje, Application.ProductName, MessageBoxButtons.OK, respuesta.Codigo_MF_Numero == "0" ? MessageBoxIcon.Information : MessageBoxIcon.Warning);
        }

        private void ejemplosToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }
        private void ejemplo_nota_credito()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_nota_credito" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_nota_credito" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject cfdiRelacionados = new MFObject("CfdisRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "E";
            factura["subtotal"] = "1000.00";
            factura["descuento"] = "0.00";
            factura["total"] = "1160.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "AAA010101AAA";
            receptor["nombre"] = "Accem Servicios Empresariales";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "PIEZA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "PRODUCTO PRUEBA 1";
            concepto0["valorunitario"] = "1000.00";
            concepto0["importe"] = "1000.00";

            MFObject conimps = new MFObject("Impuestos");
            MFObject contras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "1000.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["Importe"] = "160.00";
            contra0["TipoFactor"] = "Tasa";
            contras.AgregaSubnodo(contra0);
            conimps.AgregaSubnodo(contras);
            concepto0.AgregaSubnodo(conimps);
            conceptos.AgregaSubnodo(concepto0);
            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["TasaOCuota"] = "0.160000";
            itra0["Importe"] = "160.00";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void ejemplo_factura_aduana()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_aduana" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_aduana" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "1000.00";
            factura["descuento"] = "0.00";
            factura["total"] = "1160.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "AAA010101AAA";
            receptor["nombre"] = "Accem Servicios Empresariales";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            MFObject info = new MFObject("InformacionAduanera");
            info["NumeroPedimento"] = "123434755001456";
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "PIEZA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "PRODUCTO PRUEBA 1";
            concepto0["valorunitario"] = "1000.00";
            concepto0["importe"] = "1000.00";

            MFObject conimps = new MFObject("Impuestos");
            MFObject contras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "1000.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["Importe"] = "160.00";
            contra0["TipoFactor"] = "Tasa";
            contras.AgregaSubnodo(contra0);
            conimps.AgregaSubnodo(contras);
            concepto0.AgregaSubnodo(info);
            concepto0.AgregaSubnodo(conimps);
            conceptos.AgregaSubnodo(concepto0);
            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["TasaOCuota"] = "0.160000";
            itra0["Importe"] = "160.00";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void ejemplo_factura_condiciones_pago()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_condiciones_pago" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_condiciones_pago" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "1000.00";
            factura["descuento"] = "100.00";
            factura["total"] = "1060.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "AAA010101AAA";
            receptor["nombre"] = "Accem Servicios Empresariales";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "PIEZA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "PRODUCTO PRUEBA 1";
            concepto0["valorunitario"] = "1000.00";
            concepto0["importe"] = "1000.00";
            concepto0["Descuento"] = "100.00";
            MFObject conimps = new MFObject("Impuestos");
            MFObject contras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "1000.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["Importe"] = "160.00";
            contra0["TipoFactor"] = "Tasa";
            contras.AgregaSubnodo(contra0);
            conimps.AgregaSubnodo(contras);
            concepto0.AgregaSubnodo(conimps);
            conceptos.AgregaSubnodo(concepto0);
            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["TasaOCuota"] = "0.160000";
            itra0["Importe"] = "160.00";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void ejemplo_factura_motivo_descuento()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura_motivo_descuento" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura_motivo_descuento" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "1000.00";
            factura["descuento"] = "500.00";
            factura["total"] = "660.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "AAA010101AAA";
            receptor["nombre"] = "Accem Servicios Empresariales";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "PIEZA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "PRODUCTO PRUEBA 1";
            concepto0["valorunitario"] = "1000.00";
            concepto0["importe"] = "1000.00";
            concepto0["Descuento"] = "500.00";
            MFObject conimps = new MFObject("Impuestos");
            MFObject contras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "1000.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["Importe"] = "160.00";
            contra0["TipoFactor"] = "Tasa";
            contras.AgregaSubnodo(contra0);
            conimps.AgregaSubnodo(contras);
            concepto0.AgregaSubnodo(conimps);
            conceptos.AgregaSubnodo(concepto0);
            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["TasaOCuota"] = "0.160000";
            itra0["Importe"] = "160.00";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void ejemplo_honorarios()
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_honorarios" + ".xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_honorarios" + ".xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["tipocomprobante"] = "I";
            factura["subtotal"] = "1000.00";
            factura["descuento"] = "0.00";
            factura["total"] = "840.00";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "AAA010101AAA";
            receptor["nombre"] = "Accem Servicios Empresariales";
            receptor["UsoCFDI"] = "P01";

            // Concepto Normal
            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "84111506";
            concepto0["cantidad"] = "1";
            concepto0["unidad"] = "NO APLICA";
            concepto0["ClaveUnidad"] = "ACT";
            concepto0["descripcion"] = "SERVICIO DE MANTENIMIENTO";
            concepto0["valorunitario"] = "1000.00";
            concepto0["importe"] = "1000.00";
            MFObject conimps = new MFObject("Impuestos");
            MFObject contras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "1000.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["Importe"] = "160.00";
            contra0["TipoFactor"] = "Tasa";
            contras.AgregaSubnodo(contra0);
            conimps.AgregaSubnodo(contras);
            MFObject conrets = new MFObject("Retenciones");
            MFObject conret0 = new MFObject("0");
            conret0["Base"] = "1000.00";
            conret0["Impuesto"] = "002";
            conret0["TasaOCuota"] = "0.160000";
            conret0["Importe"] = "160.00";
            conret0["TipoFactor"] = "Tasa";
            MFObject conret1 = new MFObject("1");
            conret1["Base"] = "1000.00";
            conret1["Impuesto"] = "001";
            conret1["TasaOCuota"] = "0.160000";
            conret1["Importe"] = "160.00";
            conret1["TipoFactor"] = "Tasa";
            conrets.AgregaSubnodo(conret0);
            conrets.AgregaSubnodo(conret1);
            conimps.AgregaSubnodo(conrets);
            concepto0.AgregaSubnodo(conimps);
            conceptos.AgregaSubnodo(concepto0);
            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "160.00";
            impuestos["TotalImpuestosRetenidos"] = "320.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["TasaOCuota"] = "0.160000";
            itra0["Importe"] = "160.00";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);
            MFObject irets = new MFObject("retenciones");
            MFObject iret0 = new MFObject("0");
            iret0["Impuesto"] = "002";
            iret0["Importe"] = "160.00";
            MFObject iret1 = new MFObject("1");
            iret1["Impuesto"] = "001";
            iret1["Importe"] = "160.00";
            irets.AgregaSubnodo(iret0);
            irets.AgregaSubnodo(iret1);
            impuestos.AgregaSubnodo(irets);
            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void otroComplementoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.3");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("complemento", "detallista10");
            sdk.Iniciales.Add("cfdi", @"C:\sdk2\timbrados\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("xml_debug", @"C:\sdk2\timbrados\sin_timbrar_ejemplo_factura.xml");
            sdk.Iniciales.Add("remueve_acentos", "NO");
            sdk.Iniciales.Add("RESPUESTA_UTF8", "SI");
            sdk.Iniciales.Add("html_a_txt", "NO");
            MFObject factura = new MFObject("factura");
            factura["serie"] = "F";
            factura["folio"] = "123";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "PUE";
            factura["forma_pago"] = "01";
            factura["condicionesDePago"] = "condiciones";
            factura["tipocomprobante"] = "I";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1";
            factura["LugarExpedicion"] = "27000";
            factura["RegimenFiscal"] = "601";
            factura["subtotal"] = "1000.00";
            factura["total"] = "1112.00";

            MFObject cfdiRelacionados = new MFObject("CfdisRelacionados");
            MFObject cfdirel = new MFObject("UUID");
            cfdiRelacionados["TipoRelacion"] = "01";
            //Se pueden agregar varios relacionados con UUID
            cfdirel["0"] = "9FB6ED1A-5F37-4FEF-980A-7F8C83B51894";
            cfdirel["1"] = "4329C28A-FEDB-9016-754A-FACEB0041996";
            cfdiRelacionados.AgregaSubnodo(cfdirel);

            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "CINDEMEX SA DE CV";
            emisor["RegimenFiscal"] = "601";

            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "XAXX010101000";
            receptor["nombre"] = "Público en general";
            receptor["UsoCFDI"] = "G01";

            MFObject conceptos = new MFObject("conceptos");
            MFObject concepto0 = new MFObject("0");
            concepto0["ClaveProdServ"] = "01010101";
            concepto0["NoIdentificacion"] = "COD01";
            concepto0["Cantidad"] = "1.00";
            concepto0["ClaveUnidad"] = "C81";
            concepto0["Descripcion"] = "Producto de prueba 1";
            concepto0["ValorUnitario"] = "700.00";
            concepto0["Importe"] = "700.00";
            MFObject conimp0 = new MFObject("Impuestos");
            MFObject conimp0tras = new MFObject("Traslados");
            MFObject contra0 = new MFObject("0");
            contra0["Base"] = "700.00";
            contra0["Importe"] = "112.00";
            contra0["Impuesto"] = "002";
            contra0["TasaOCuota"] = "0.160000";
            contra0["TipoFactor"] = "Tasa";
            conimp0tras.AgregaSubnodo(contra0);
            conimp0.AgregaSubnodo(conimp0tras);
            concepto0.AgregaSubnodo(conimp0);

            conceptos.AgregaSubnodo(concepto0);

            // Impuestos
            MFObject impuestos = new MFObject("impuestos");
            impuestos["TotalImpuestosTrasladados"] = "112.00";
            // Traslados
            MFObject itras = new MFObject("translados");
            MFObject itra0 = new MFObject("0");
            itra0["Impuesto"] = "002";
            itra0["Importe"] = "112.00";
            itra0["TasaOCuota"] = "0.160000";
            itra0["TipoFactor"] = "Tasa";
            itras.AgregaSubnodo(itra0);
            impuestos.AgregaSubnodo(itras);

            sdk.AgregaObjeto(PAC());
            sdk.AgregaObjeto(Conf());
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(cfdiRelacionados);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            sdk.AgregaObjeto(complementoDetallista());

            // Muestras la estructura
            MostrarDatos(sdk);
        }

        private void factura32ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //Datos de factura
            sdk = new MFSDK();
            sdk.Iniciales.Add("version_cfdi", "3.2");
            sdk.Iniciales.Add("MODOINI", "DIVISOR");
            sdk.Iniciales.Add("cfdi", "timbrados/cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("xml_debug", "timbrados/sin_timbrar_ejemplo_factura.xml");
            sdk.Iniciales.Add("php_openssl", "SI");
            //**********Nota: Verifique los nombres y que los objetos agregados sean correctos**********
            MFObject PAC = new MFObject("PAC");
            PAC["usuario"] = "DEMO700101XXX";
            PAC["pass"] = "DEMO700101XXX";
            PAC["produccion"] = "NO";
            MFObject conf = new MFObject("conf");
            conf["cer"] = "C:/SDK2/certificados/lan7008173r5.cer.pem";
            conf["key"] = "C:/SDK2/certificados/lan7008173r5.key.pem";
            conf["pass"] = "12345678a";

            MFObject factura = new MFObject("factura");
            factura["serie"] = "A";
            factura["folio"] = "100";
            factura["fecha_expedicion"] = DateTime.Now.ToString("s");
            factura["metodo_pago"] = "EFECTIVO";
            factura["forma_pago"] = "PAGO EN UNA SOLA EXHIBICION";
            factura["tipocomprobante"] = "ingreso";
            factura["moneda"] = "MXN";
            factura["tipocambio"] = "1.0000";
            factura["LugarExpedicion"] = "MONTERREY, NUEVO LEON";
            factura["RegimenFiscal"] = "MI REGIMEN";
            factura["subtotal"] = "1000";
            factura["total"] = "1160";
            MFObject emisor = new MFObject("emisor");
            emisor["rfc"] = "LAN7008173R5";
            emisor["nombre"] = "ACCEM SERVICIOS EMPRESARIALES SC";
            MFObject emisorDomicilioFiscal = new MFObject("DomicilioFiscal");
            emisorDomicilioFiscal["calle"] = "JUAREZ";
            emisorDomicilioFiscal["noExterior"] = "100";
            emisorDomicilioFiscal["noInterior"] = "";
            emisorDomicilioFiscal["colonia"] = "CENTRO";
            emisorDomicilioFiscal["localidad"] = "MONTERREY";
            emisorDomicilioFiscal["municipio"] = "MONTERREY";
            emisorDomicilioFiscal["estado"] = "NUEVO LEON";
            emisorDomicilioFiscal["pais"] = "MEXICO";
            emisorDomicilioFiscal["CodigoPostal"] = "01234";
            MFObject emisorExpedidoEn = new MFObject("ExpedidoEn");
            emisorExpedidoEn["calle"] = "HIDALGO";
            emisorExpedidoEn["noExterior"] = "240";
            emisorExpedidoEn["noInterior"] = "";
            emisorExpedidoEn["colonia"] = "LAS CUMBRES 3 SECTOR";
            emisorExpedidoEn["localidad"] = "MONTERREY";
            emisorExpedidoEn["municipio"] = "MONTERREY";
            emisorExpedidoEn["estado"] = "NUEVO LEON";
            emisorExpedidoEn["pais"] = "MEXICO";
            emisorExpedidoEn["CodigoPostal"] = "64610";
            MFObject receptor = new MFObject("receptor");
            receptor["rfc"] = "SOHM7509289MA";
            receptor["nombre"] = "MIGUEL ANGEL SOSA HERNANDEZ";
            MFObject receptorDomicilio = new MFObject("Domicilio");
            receptorDomicilio["calle"] = "PERIFERICO";
            receptorDomicilio["noExterior"] = "1024";
            receptorDomicilio["noInterior"] = "B";
            receptorDomicilio["colonia"] = "SAN ANGEL";
            receptorDomicilio["localidad"] = "CIUDAD DE MÉXICO";
            receptorDomicilio["municipio"] = "ALVARO OBREGON";
            receptorDomicilio["estado"] = "DISTRITO FEDERAL";
            receptorDomicilio["pais"] = "MEXICO";
            receptorDomicilio["CodigoPostal"] = "23010";
            MFObject conceptos = new MFObject("conceptos");
            MFObject conceptos0 = new MFObject("0");
            conceptos0["unidad"] = "PIEZA";
            conceptos0["cantidad"] = "1";
            conceptos0["ID"] = "COD";
            conceptos0["descripcion"] = "PRODUCTO PRUEBA";
            conceptos0["valorunitario"] = "1000.00";
            conceptos0["importe"] = "1000.00";
            conceptos0["numero"] = "123434755001456";
            conceptos0["fecha"] = "2015-09-25";
            conceptos0["aduana"] = "NUEVO LAREDO";

            MFObject impuestos = new MFObject("impuestos");
            MFObject translados = new MFObject("translados");
            MFObject tra0 = new MFObject("0");
            tra0["importe"] = "160.00";
            tra0["impuesto"] = "IVA";
            tra0["tasa"] = "0.16";
            translados.AgregaSubnodo(tra0);
            impuestos.AgregaSubnodo(translados);

            emisor.AgregaSubnodo(emisorDomicilioFiscal);
            emisor.AgregaSubnodo(emisorExpedidoEn);
            receptor.AgregaSubnodo(receptorDomicilio);
            conceptos.AgregaSubnodo(conceptos0);
            sdk.AgregaObjeto(PAC);
            sdk.AgregaObjeto(conf);
            sdk.AgregaObjeto(factura);
            sdk.AgregaObjeto(emisor);
            sdk.AgregaObjeto(receptor);
            sdk.AgregaObjeto(conceptos);
            sdk.AgregaObjeto(impuestos);
            MostrarDatos(sdk); // Muestra la estructura
        }

        private void cancelarToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.AgregaObjeto(PAC2());
            sdk.Iniciales.Add("modulo", "cancelacion2018");
            sdk.Iniciales.Add("accion", "cancelar");
            sdk.Iniciales.Add("produccion", "NO");
            sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d");
            sdk.Iniciales.Add("rfc", "LAN7008173R5");
            //sdk.Iniciales.Add("cfdi", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("password", "12345678a");
            sdk.Iniciales.Add("b64Cer", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer");
            sdk.Iniciales.Add("b64Key", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key");

            //sdk.AgregaObjeto(Conf());
            MostrarDatos(sdk);
        }

        private void consultarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.AgregaObjeto(PAC2());
            sdk.Iniciales.Add("modulo", "cancelacion2018");
            sdk.Iniciales.Add("accion", "consultar");
            sdk.Iniciales.Add("produccion", "NO");
            sdk.Iniciales.Add("rfc", "LAN7008173R5");
            sdk.Iniciales.Add("password", "12345678a");
            MostrarDatos(sdk);
        }

        private void aceptarCancelacionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("modulo", "cancelacion2018");
            sdk.Iniciales.Add("accion", "aceptar");
            sdk.Iniciales.Add("produccion", "NO");
            sdk.Iniciales.Add("rfc", "LAN7008173R5");
            sdk.Iniciales.Add("password", "12345678a");
            sdk.Iniciales.Add("xml", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d");
            sdk.Iniciales.Add("b64Cer", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer");
            sdk.Iniciales.Add("b64Key", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key");

            //sdk.AgregaObjeto(Conf());
            MostrarDatos(sdk);
        }

        private void rechazarCancelacionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            sdk = new MFSDK();
            sdk.Iniciales.Add("modulo", "cancelacion2018");
            sdk.Iniciales.Add("accion", "rechazar");
            sdk.Iniciales.Add("produccion", "NO");
            sdk.Iniciales.Add("uuid", "25d57a90-77cc-4fe2-acf6-67a3c2f2508d");
            sdk.Iniciales.Add("password", "12345678a");
            sdk.Iniciales.Add("rfc", "LAN7008173R5");
            sdk.Iniciales.Add("xml", "C:\\sdk2\\timbrados\\cfdi_ejemplo_factura.xml");
            sdk.Iniciales.Add("b64Cer", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.cer");
            sdk.Iniciales.Add("b64Key", @"C:\SDK2\ejemplos\modulos\Certificados\lan7008173r5.key");

            //sdk.AgregaObjeto(Conf());
            MostrarDatos(sdk);
        }
    }
}
